/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.linearwalker;

import ow.routing.RoutingAlgorithmConfiguration;

public class LinearWalkerConfiguration
extends RoutingAlgorithmConfiguration {
    public static final int DEFAULT_SUCCESSOR_LIST_LENGTH = 8;
    public static final boolean DEFAULT_AGGRESSIVE_JOINING_MODE = false;
    public static final long DEFAULT_STABILIZE_MIN_INTERVAL = 2000L;
    public static final long DEFAULT_STABILIZE_MAX_INTERVAL = 128000L;
    public static final double DEFAULT_STABILIZE_INTERVAL_PLAY_RATIO = 0.3;
    private int successorListLength = 8;
    private boolean aggressiveJoining = false;
    private long stabilizeMinInterval = 2000L;
    private long stabilizeMaxInterval = 128000L;
    private double stabilizeIntervalPlayRatio = 0.3;

    protected LinearWalkerConfiguration() {
    }

    public boolean adjustRoot() {
        return true;
    }

    public int getSuccessorListLength() {
        return this.successorListLength;
    }

    public int setSuccessorListLength(int len) {
        int old = this.successorListLength;
        this.successorListLength = len;
        return old;
    }

    public boolean getAggressiveJoiningMode() {
        return this.aggressiveJoining;
    }

    public boolean setAggressiveJoiningMode(boolean flag) {
        boolean old = this.aggressiveJoining;
        this.aggressiveJoining = flag;
        return old;
    }

    public long getStabilizeMinInterval() {
        return this.stabilizeMinInterval;
    }

    public long setStabilizeMinInterval(long interval) {
        long old = this.stabilizeMinInterval;
        this.stabilizeMinInterval = interval;
        return old;
    }

    public long getStabilizeMaxInterval() {
        return this.stabilizeMaxInterval;
    }

    public long setStabilizeMaxInterval(long interval) {
        long old = this.stabilizeMaxInterval;
        this.stabilizeMaxInterval = interval;
        return old;
    }

    public double getStabilizeIntervalPlayRatio() {
        return this.stabilizeIntervalPlayRatio;
    }

    public double setStabilizeIntervalPlayRatio(double play) {
        double old = this.stabilizeIntervalPlayRatio;
        this.stabilizeIntervalPlayRatio = play;
        return old;
    }
}

