/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ow.id.IDAddressPair;
import ow.routing.impl.ContactList;

public abstract class AbstractContactList
implements ContactList {
    protected int maxNodes;
    protected Set<IDAddressPair> contactedSet;
    protected Map<IDAddressPair, IDAddressPair> lastContactMap;

    public AbstractContactList(int maxNodes) {
        this.maxNodes = maxNodes;
        this.contactedSet = new HashSet<IDAddressPair>();
        this.lastContactMap = new HashMap<IDAddressPair, IDAddressPair>();
    }

    public synchronized int numOfContactedNodes() {
        return this.contactedSet.size();
    }

    public synchronized boolean addAsContacted(IDAddressPair contact, IDAddressPair lastContact) {
        boolean ret = this.add(contact, lastContact);
        this.contactedSet.add(contact);
        return ret;
    }

    public synchronized boolean isContactedNode(IDAddressPair node) {
        return this.contactedSet.contains(node);
    }

    public synchronized IDAddressPair getLastContactOf(IDAddressPair contact) {
        return this.lastContactMap.get(contact);
    }
}

