/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.chord;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.util.Random;
import java.util.logging.Level;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.messaging.Tag;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingResult;
import ow.routing.RoutingService;
import ow.routing.chord.AbstractChord;
import ow.routing.chord.ChordConfiguration;

public final class Chord
extends AbstractChord {
    private ChordConfiguration config;
    private Thread fingerTableFixerThread;

    protected Chord(RoutingAlgorithmConfiguration config, RoutingService routingSvc) throws InvalidAlgorithmParameterException {
        super(config, routingSvc);
        try {
            this.config = (ChordConfiguration)config;
        }
        catch (ClassCastException e) {
            throw new InvalidAlgorithmParameterException("The given config is not ChordConfiguration.");
        }
        FingerTableFixer r = new FingerTableFixer();
        this.fingerTableFixerThread = new Thread(r);
        this.fingerTableFixerThread.setName("FingerTableFixer");
        this.fingerTableFixerThread.setDaemon(true);
        this.fingerTableFixerThread.start();
    }

    public synchronized void stop() {
        logger.log(Level.INFO, "Chord#stop() called.");
        super.stop();
        if (this.fingerTableFixerThread != null) {
            this.fingerTableFixerThread.interrupt();
            this.fingerTableFixerThread = null;
        }
    }

    public void prepareHandlers() {
        super.prepareHandlers();
        ReqConnectMessageHandler handler = new ReqConnectMessageHandler();
        this.runtime.addMessageHandler(Tag.REQ_CONNECT.getNumber(), handler);
    }

    private class FingerTableFixer
    implements Runnable {
        private Random rnd = new Random(System.currentTimeMillis());

        private FingerTableFixer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long minInterval = Chord.this.config.getFixFingersMinInterval();
            long maxInterval = Chord.this.config.getFixFingersMaxInterval();
            try {
                while (true) {
                    int numFingers = Chord.this.fingerTable.numOfDifferentEntries();
                    double ratio = Math.log(numFingers + 1) / Math.log(Chord.this.idSizeInBit + 1);
                    long interval = minInterval + (long)((double)(maxInterval - minInterval) * ratio);
                    double playRatio = Chord.this.config.getFixFingersIntervalPlayRatio();
                    double intervalRatio = 1.0 - playRatio + playRatio * 2.0 * this.rnd.nextDouble();
                    Thread.sleep((long)((double)interval * intervalRatio));
                    if (!Chord.this.stopped) {
                        while (Chord.this.suspended) {
                            Chord chord = Chord.this;
                            synchronized (chord) {
                                Chord.this.wait();
                            }
                        }
                        int i = this.rnd.nextInt(Chord.this.idSizeInBit - 1) + 2;
                        boolean optimize = false;
                        BigInteger fingerEdgeDistance = optimize ? BigInteger.ONE.shiftLeft(i) : BigInteger.ONE.shiftLeft(i - 1);
                        BigInteger fingerStartBigInteger = Chord.this.selfIDAddress.getID().toBigInteger().add(fingerEdgeDistance);
                        ID fingerEdge = ID.getID(fingerStartBigInteger, Chord.this.config.getIDSizeInByte());
                        RoutingResult res = optimize ? Chord.this.runtime.routeToClosestNode(fingerEdge, 1) : Chord.this.runtime.routeToRootNode(fingerEdge, 1);
                        IDAddressPair[] route = res.getRoute();
                        IDAddressPair rootNode = route[route.length - 1];
                        if (rootNode.getID().equals(Chord.this.selfIDAddress.getID())) continue;
                        IDAddressPair oldFinger = Chord.this.fingerTable.get(i);
                        Chord.this.fingerTable.put(rootNode);
                        Chord.this.successorList.add(rootNode);
                        if (Chord.this.fingerTable.get(i).equals(oldFinger)) continue;
                        logger.log(Level.INFO, "finger[" + i + "].start updated.");
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "FingerTableFixer interrupted and die.", e);
            }
        }
    }

    class ReqConnectMessageHandler
    extends AbstractChord.ReqConnectMessageHandler {
        ReqConnectMessageHandler() {
        }
    }
}

