/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging.udp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import ow.messaging.AbstractMessagingProvider;
import ow.messaging.MessageReceiver;
import ow.messaging.MessagingAddress;
import ow.messaging.MessagingConfiguration;
import ow.messaging.MessagingProvider;
import ow.messaging.timeoutcalc.RTTBasedTimeoutCalculator;
import ow.messaging.timeoutcalc.StaticTimeoutCalculator;
import ow.messaging.timeoutcalc.TimeoutCalculator;
import ow.messaging.udp.UDPMessageReceiver;
import ow.messaging.udp.UDPMessagingAddress;
import ow.messaging.udp.UDPMessagingConfiguration;

public class UDPMessagingProvider
extends AbstractMessagingProvider {
    private static final String NAME = "UDP";
    private final Map<Integer, UDPMessageReceiver> receiverTable = Collections.synchronizedMap(new HashMap());
    private InetAddress selfInetAddress = null;
    private TimeoutCalculator timeoutCalculator = null;
    private MessagingAddress statCollectorAddress = null;

    public String getName() {
        return NAME;
    }

    public boolean isReliable() {
        return false;
    }

    public MessagingConfiguration getDefaultConfiguration() {
        return new UDPMessagingConfiguration();
    }

    public MessageReceiver getReceiver(MessagingConfiguration config, int port) throws IOException {
        return this.getReceiver(config, port, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageReceiver getReceiver(MessagingConfiguration config, int port, int portRange) throws IOException {
        UDPMessagingProvider uDPMessagingProvider = this;
        synchronized (uDPMessagingProvider) {
            this.timeoutCalculator = config.getDoTimeoutCalculation() ? new StaticTimeoutCalculator(config) : new RTTBasedTimeoutCalculator(config);
        }
        UDPMessageReceiver receiver = this.receiverTable.get(port);
        if (receiver == null) {
            receiver = new UDPMessageReceiver(this.selfInetAddress, port, portRange, (UDPMessagingConfiguration)config, this);
            this.receiverTable.put(port, receiver);
            receiver.start();
        }
        return receiver;
    }

    public UDPMessagingAddress getMessagingAddress(String hostname, int port) throws UnknownHostException {
        return new UDPMessagingAddress(hostname, port);
    }

    public UDPMessagingAddress getMessagingAddress(String hostAndPort) throws UnknownHostException {
        return new UDPMessagingAddress(hostAndPort);
    }

    protected UDPMessagingAddress getMessagingAddress(InetSocketAddress inetSockAddress) {
        return new UDPMessagingAddress(inetSockAddress);
    }

    public UDPMessagingAddress getMessagingAddress(int port) {
        return new UDPMessagingAddress(port);
    }

    public TimeoutCalculator getTimeoutCalculator() {
        return this.timeoutCalculator;
    }

    public MessagingAddress getStatCollectorAddress() {
        return this.statCollectorAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessagingAddress setStatCollectorAddress(MessagingAddress addr) {
        MessagingAddress old;
        UDPMessagingProvider uDPMessagingProvider = this;
        synchronized (uDPMessagingProvider) {
            old = this.statCollectorAddress;
            this.statCollectorAddress = addr;
        }
        return old;
    }

    public MessagingProvider substitute() {
        return null;
    }

    public void setDefaultSelfAddress(String host) throws UnknownHostException {
        this.selfInetAddress = InetAddress.getByName(host);
    }
}

