/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging.udp;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import ow.messaging.MessagingAddress;
import ow.messaging.util.MessagingUtility;

public final class UDPMessagingAddress
implements MessagingAddress {
    private InetSocketAddress addr;

    UDPMessagingAddress(int port) {
        this.addr = new InetSocketAddress(port);
    }

    UDPMessagingAddress(InetAddress addr, int port) {
        this.addr = new InetSocketAddress(addr, port);
    }

    UDPMessagingAddress(InetSocketAddress addr) {
        this.addr = addr;
    }

    UDPMessagingAddress(String hostAndPort, int defaultPort) throws UnknownHostException {
        this.addr = MessagingUtility.parseHostnameAndPort(hostAndPort, defaultPort).getInetSocketAddress();
    }

    UDPMessagingAddress(String hostAndPort) throws UnknownHostException {
        this.addr = MessagingUtility.parseHostnameAndPort(hostAndPort).getInetSocketAddress();
    }

    public String getHostAddress() {
        return this.addr.getAddress().getHostAddress();
    }

    public String getHostname() {
        return this.addr.getAddress().getHostName();
    }

    protected void setInetAddress(InetAddress addr) {
        int port = this.addr.getPort();
        this.addr = new InetSocketAddress(addr, port);
    }

    public int getPort() {
        return this.addr.getPort();
    }

    protected InetSocketAddress getInetSocketAddress() {
        return this.addr;
    }

    protected InetAddress getInetAddress() {
        return this.addr.getAddress();
    }

    public int hashCode() {
        return this.addr.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof UDPMessagingAddress) {
            return this.addr.equals(((UDPMessagingAddress)o).addr);
        }
        return false;
    }

    public String toString() {
        return this.addr.toString();
    }
}

