/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging.udp;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.id.IDAddressPair;
import ow.messaging.Message;
import ow.messaging.MessageSender;
import ow.messaging.MessagingAddress;
import ow.messaging.Tag;
import ow.messaging.timeoutcalc.TimeoutCalculator;
import ow.messaging.udp.SocketPool;
import ow.messaging.udp.UDPMessageReceiver;
import ow.messaging.udp.UDPMessagingAddress;
import ow.messaging.udp.UDPMessagingProvider;
import ow.msgstat.StatReporter;
import ow.util.Timer;

public final class UDPMessageSender
implements MessageSender {
    private static final Logger logger = Logger.getLogger("messaging");
    protected static int MAX_MSG_SIZE = 65536;
    private final SocketPool sockPool;
    private final UDPMessagingProvider provider;
    private final UDPMessageReceiver receiver;
    private final TimeoutCalculator timeoutCalc;
    private StatReporter statReporter;
    private final boolean forReceiver;
    private DatagramChannel receiverSock = null;

    protected UDPMessageSender(SocketPool sockPool, UDPMessagingProvider provider, UDPMessageReceiver receiver, StatReporter statReporter, boolean forReceiver) {
        this.sockPool = sockPool;
        this.provider = provider;
        this.receiver = receiver;
        this.timeoutCalc = provider.getTimeoutCalculator();
        this.statReporter = statReporter;
        this.forReceiver = forReceiver;
        if (this.forReceiver) {
            this.receiverSock = this.receiver.sock;
        }
    }

    public void setStatReporter(StatReporter statReporter) {
        this.statReporter = statReporter;
    }

    public void send(MessagingAddress dest, Message msg) throws IOException {
        this.adjustLoopbackAddress((UDPMessagingAddress)dest);
        DatagramChannel sock = !this.forReceiver ? this.sockPool.get() : this.receiverSock;
        this.send(sock, ((UDPMessagingAddress)dest).getInetSocketAddress(), dest, msg, false);
        if (!this.forReceiver) {
            this.sockPool.put(sock);
        }
    }

    protected void send(DatagramChannel sock, SocketAddress sockAddr, MessagingAddress dest, Message msg, boolean isReply) throws IOException {
        int tag = msg.getTag();
        if (tag != Tag.PUNCH_HOLE_REQ.getNumber() && tag != Tag.PUNCH_HOLE_REP.getNumber() && dest != null && !this.receiver.getSelfAddress().equals(dest) && !isReply && this.receiver.beginFirstPunching()) {
            this.receiver.lastSendDest = (UDPMessagingAddress)dest;
            this.receiver.punchHole();
            IDAddressPair src = msg.getSource();
            if (src != null) {
                src.setAddress(this.receiver.getSelfAddress());
            }
        }
        logger.log(Level.INFO, "send(" + (dest != null ? dest : sockAddr) + ", " + Tag.getStringByNumber(msg.getTag()) + ")");
        byte[] sig = this.provider.getMessageSignature();
        msg.setSignature(sig);
        ByteBuffer buf = Message.encode(msg);
        int payloadLen = buf.remaining();
        if (payloadLen >= MAX_MSG_SIZE) {
            logger.log(Level.WARNING, "message is too large: " + payloadLen);
            throw new IOException("message is too large: " + payloadLen);
        }
        try {
            sock.send(buf, sockAddr);
            if (dest != null) {
                this.receiver.setLastSend((UDPMessagingAddress)dest);
                if (this.statReporter != null) {
                    this.statReporter.notifyStatCollectorOfMessageSent(dest, msg);
                }
            }
        }
        catch (IOException e) {
            if (dest != null && this.statReporter != null) {
                this.statReporter.notifyStatCollectorOfDeletedNode(msg.getSource(), dest, msg.getTag());
            }
            throw e;
        }
    }

    public Message sendAndReceive(MessagingAddress dest, Message msg) throws IOException {
        this.adjustLoopbackAddress((UDPMessagingAddress)dest);
        Message ret = null;
        DatagramChannel sock = !this.forReceiver ? this.sockPool.get() : this.receiverSock;
        long timeout = this.timeoutCalc.calculateTimeout(dest);
        long start = System.currentTimeMillis();
        this.send(sock, ((UDPMessagingAddress)dest).getInetSocketAddress(), dest, msg, false);
        try {
            Timer.setTimer(timeout);
            ByteBuffer buf = ByteBuffer.allocate(MAX_MSG_SIZE);
            sock.receive(buf);
            buf.rewind();
            ret = Message.decode(buf);
            Timer.clearTimer();
            this.timeoutCalc.updateRTT(dest, (int)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            Thread.interrupted();
            logger.log(Level.INFO, "Timeout: " + timeout + " msec.");
            if (this.statReporter != null) {
                this.statReporter.notifyStatCollectorOfDeletedNode(msg.getSource(), dest, msg.getTag());
            }
            throw new IOException("Timeout:" + timeout + " msec.");
        }
        if (!this.forReceiver) {
            this.sockPool.put(sock);
        }
        return ret;
    }

    private void adjustLoopbackAddress(UDPMessagingAddress dest) {
        if (dest.getInetAddress().isLoopbackAddress()) {
            dest.setInetAddress(((UDPMessagingAddress)this.receiver.getSelfAddress()).getInetAddress());
            logger.log(Level.INFO, "destination is loopback address and adjusted to " + dest);
        }
    }
}

