/*
 * Decompiled with CFR 0.152.
 */
package ow.directory.hashmap;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.directory.Directory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashDirectory<K, V>
implements Directory<K, V> {
    private static final Logger logger = Logger.getLogger("map");
    private final String dbName;
    private final String dbNameOld;
    private long syncInterval;
    private HashMap<K, V> rawMap;
    private Map<K, V> map;
    private boolean changed = false;
    private Synchronizer synchronizer;

    protected HashDirectory(Class typeK, Class typeV, String workingDir, String dbName, String dbNameOld, long syncInterval) throws Exception {
        this.dbName = dbName;
        this.dbNameOld = dbNameOld;
        this.syncInterval = syncInterval;
        boolean loaded = false;
        if (syncInterval > 0L) {
            File dbFile;
            if (!workingDir.endsWith(File.separator)) {
                workingDir = workingDir + File.separator;
            }
            if ((dbFile = new File(workingDir + this.dbName)).exists()) {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(dbFile));
                this.rawMap = (HashMap)ois.readObject();
                ois.close();
                loaded = true;
            }
        }
        if (!loaded) {
            this.rawMap = new HashMap();
        }
        this.map = Collections.synchronizedMap(this.rawMap);
        if (this.syncInterval > 0L) {
            this.synchronizer = new Synchronizer(this.syncInterval, workingDir + this.dbName, workingDir + this.dbNameOld);
            Thread t = new Thread(this.synchronizer);
            t.setDaemon(true);
            t.setName("Map synchronizer");
            t.start();
        }
    }

    @Override
    public V put(K key, V value) {
        V ret = this.map.put(key, value);
        this.changed = true;
        return ret;
    }

    @Override
    public V get(K key) {
        return this.map.get(key);
    }

    @Override
    public V remove(K key) {
        V ret = this.map.remove(key);
        this.changed = true;
        return ret;
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public void clear() {
        this.map.clear();
        this.changed = true;
    }

    @Override
    public void close() {
        if (this.synchronizer != null) {
            this.synchronizer.sync();
        }
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.map.entrySet().iterator();
    }

    private class Synchronizer
    implements Runnable {
        private long syncInterval;
        private File file;
        private File oldfile;
        private File tmpfile;

        Synchronizer(long syncInterval, String filename, String oldfilename) {
            this.syncInterval = syncInterval;
            this.file = new File(filename);
            this.oldfile = new File(oldfilename);
            this.tmpfile = new File(filename + ".tmp");
        }

        public void run() {
            while (true) {
                try {
                    Thread.sleep(this.syncInterval);
                }
                catch (InterruptedException e) {
                    logger.log(Level.INFO, "A Synchronized interrupted.", e);
                }
                this.sync();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void sync() {
            if (HashDirectory.this.changed) {
                ObjectOutputStream oos = null;
                try {
                    oos = new ObjectOutputStream(new FileOutputStream(this.tmpfile));
                    Map map = HashDirectory.this.map;
                    synchronized (map) {
                        oos.writeObject(HashDirectory.this.rawMap);
                        oos.close();
                    }
                    this.file.renameTo(this.oldfile);
                    this.tmpfile.renameTo(this.file);
                    HashDirectory.this.changed = false;
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Could not open, write or rename.", e);
                }
                finally {
                    try {
                        if (oos != null) {
                            oos.close();
                        }
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Could not close file streams.", e);
                    }
                }
            }
        }
    }
}

