/*
 * Decompiled with CFR 0.152.
 */
package ow.directory.berkeleydb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import ow.directory.DupDirectory;
import ow.directory.berkeleydb.AbstractJEDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JEDupDirectory<K, V>
extends AbstractJEDirectory<K, V>
implements DupDirectory<K, V> {
    protected JEDupDirectory(Class typeK, Class typeV, Environment env, String dbName) throws Exception {
        super(typeK, typeV, env, dbName, true);
    }

    @Override
    public V put(K key, V value) throws Exception {
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = new DatabaseEntry();
        this.keyBinding.objectToEntry(key, keyEntry);
        this.dataBinding.objectToEntry(value, dataEntry);
        Object ret = null;
        Transaction txn = this.env.beginTransaction(null, null);
        Cursor cursor = this.db.openCursor(txn, null);
        if (cursor.getSearchKey(keyEntry, dataEntry, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
            Object v = this.dataBinding.entryToObject(dataEntry);
            if (value.equals(v)) {
                ret = v;
                cursor.delete();
            } else {
                while (cursor.getNextDup(keyEntry, dataEntry, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                    v = this.dataBinding.entryToObject(dataEntry);
                    if (!value.equals(v)) continue;
                    ret = v;
                    cursor.delete();
                    break;
                }
            }
        }
        this.keyBinding.objectToEntry(key, keyEntry);
        this.dataBinding.objectToEntry(value, dataEntry);
        if (cursor.put(keyEntry, dataEntry) != OperationStatus.SUCCESS) {
            String msg = "Could not put: " + key + ", " + value;
            logger.log(Level.WARNING, msg);
            throw new DatabaseException(msg);
        }
        cursor.close();
        txn.commit();
        return (V)ret;
    }

    @Override
    public Set<V> get(K key) throws DatabaseException {
        return this.getAndRemove(key, false);
    }

    @Override
    public Set<V> remove(K key) throws DatabaseException {
        return this.getAndRemove(key, true);
    }

    private Set<V> getAndRemove(K key, boolean remove) throws DatabaseException {
        DatabaseEntry searchKey = new DatabaseEntry();
        this.keyBinding.objectToEntry(key, searchKey);
        DatabaseEntry foundKey = new DatabaseEntry();
        DatabaseEntry foundData = new DatabaseEntry();
        Transaction txn = this.env.beginTransaction(null, null);
        Cursor cursor = this.db.openCursor(txn, null);
        HashSet<Object> s = null;
        if (cursor.getSearchKey(searchKey, foundData, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
            s = new HashSet<Object>();
            s.add(this.dataBinding.entryToObject(foundData));
            while (cursor.getNextDup(foundKey, foundData, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                s.add(this.dataBinding.entryToObject(foundData));
            }
        }
        if (remove) {
            this.db.delete(txn, searchKey);
        }
        cursor.close();
        txn.commit();
        return s;
    }

    @Override
    public V remove(K key, V value) throws Exception {
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry foundEntry = new DatabaseEntry();
        this.keyBinding.objectToEntry(key, keyEntry);
        Object ret = null;
        Transaction txn = this.env.beginTransaction(null, null);
        Cursor cursor = this.db.openCursor(txn, null);
        if (cursor.getSearchKey(keyEntry, foundEntry, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
            do {
                Object v;
                if (!value.equals(v = this.dataBinding.entryToObject(foundEntry))) continue;
                ret = v;
                cursor.delete();
                break;
            } while (cursor.getNextDup(keyEntry, foundEntry, LockMode.DEFAULT) == OperationStatus.SUCCESS);
        }
        cursor.close();
        txn.commit();
        return (V)ret;
    }
}

