/*
 * Decompiled with CFR 0.152.
 */
package ow.directory.berkeleydb;

import com.sleepycat.bind.ByteArrayBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.directory.berkeleydb.IDBinding;
import ow.id.ID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJEDirectory<K, V> {
    static final Logger logger = Logger.getLogger("map");
    private final String dbName;
    Environment env;
    Database db;
    SortedMap<K, V> map;
    EntryBinding keyBinding;
    EntryBinding dataBinding;
    private ClassCatalog catalog;
    private boolean catalogPrepared = false;

    protected AbstractJEDirectory(Class typeK, Class typeV, Environment env, String dbName, boolean allowDuplicates) throws Exception {
        this.env = env;
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setTransactional(true);
        dbConfig.setAllowCreate(true);
        if (allowDuplicates) {
            dbConfig.setSortedDuplicates(true);
        }
        this.keyBinding = this.getBinding(typeK);
        this.dataBinding = this.getBinding(typeV);
        Transaction txn = env.beginTransaction(null, null);
        this.dbName = dbName;
        this.db = env.openDatabase(null, this.dbName, dbConfig);
        txn.commit();
        this.map = new StoredSortedMap(this.db, this.keyBinding, this.dataBinding, true);
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public void clear() {
        this.map.clear();
    }

    public void close() {
        try {
            if (this.catalog != null) {
                this.catalog.close();
                this.catalog = null;
            }
            if (this.db != null) {
                this.db.close();
                this.db = null;
            }
        }
        catch (DatabaseException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    public Iterator<Map.Entry<K, V>> iterator() {
        return new JEDirectoryIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntryBinding getBinding(Class type) throws DatabaseException {
        TupleBinding binding = null;
        if (type.equals(ID.class)) {
            return new IDBinding();
        }
        if (type.equals(String.class) || type.equals(Character.class) || type.equals(Boolean.class) || type.equals(Byte.class) || type.equals(Short.class) || type.equals(Integer.class) || type.equals(Long.class) || type.equals(Float.class) || type.equals(Double.class)) {
            binding = TupleBinding.getPrimitiveBinding((Class)type);
        } else if (type.equals(byte[].class)) {
            binding = new ByteArrayBinding();
        } else {
            AbstractJEDirectory abstractJEDirectory = this;
            synchronized (abstractJEDirectory) {
                if (!this.catalogPrepared) {
                    DatabaseConfig dbConfig = new DatabaseConfig();
                    dbConfig.setTransactional(true);
                    dbConfig.setAllowCreate(true);
                    Database catalogDB = this.env.openDatabase(null, this.dbName + ".catalog", dbConfig);
                    this.catalog = new StoredClassCatalog(catalogDB);
                    this.catalogPrepared = true;
                }
            }
            binding = new SerialBinding(this.catalog, type);
        }
        return binding;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JEDirectoryEntry
    implements Map.Entry<K, V> {
        K key;
        V value;
        JEDirectoryIterator it = null;

        JEDirectoryEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        JEDirectoryEntry(JEDirectoryIterator it, K key, V value) {
            this.it = it;
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            Object ret = this.value;
            this.value = value;
            if (this.it != null) {
                DatabaseEntry newDataEntry = new DatabaseEntry();
                AbstractJEDirectory.this.dataBinding.objectToEntry(value, newDataEntry);
                try {
                    this.it.cursor.putCurrent(newDataEntry);
                }
                catch (DatabaseException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            return ret;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JEDirectoryIterator
    implements Iterator<Map.Entry<K, V>> {
        Transaction txn = null;
        Cursor cursor = null;
        OperationStatus lastStatus;
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = new DatabaseEntry();

        private JEDirectoryIterator() {
            try {
                this.txn = AbstractJEDirectory.this.env.beginTransaction(null, null);
                this.cursor = AbstractJEDirectory.this.db.openCursor(this.txn, null);
            }
            catch (DatabaseException e) {
                logger.log(Level.WARNING, "Could not begin transaction.");
            }
        }

        protected void finalize() throws Throwable {
            try {
                if (this.cursor != null) {
                    this.cursor.close();
                }
                this.cursor = null;
            }
            catch (DatabaseException e) {
                logger.log(Level.WARNING, "Cursor#close() failed.", e);
            }
            try {
                if (this.txn != null) {
                    this.txn.commit();
                }
                this.txn = null;
            }
            catch (DatabaseException e) {
                logger.log(Level.WARNING, "Transaction#commit() failed.", e);
            }
        }

        @Override
        public boolean hasNext() {
            try {
                this.lastStatus = this.cursor.getNext(this.keyEntry, this.dataEntry, LockMode.DEFAULT);
            }
            catch (DatabaseException e) {
                logger.log(Level.WARNING, "Cursor#getNext() throws a DatabaseException.", e);
            }
            if (this.lastStatus == OperationStatus.SUCCESS) {
                return true;
            }
            try {
                this.finalize();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }

        @Override
        public Map.Entry<K, V> next() {
            Object key = AbstractJEDirectory.this.keyBinding.entryToObject(this.keyEntry);
            Object value = AbstractJEDirectory.this.dataBinding.entryToObject(this.dataEntry);
            return new JEDirectoryEntry(this, key, value);
        }

        @Override
        public void remove() {
            try {
                this.cursor.delete();
            }
            catch (DatabaseException e) {
                logger.log(Level.WARNING, "Cursor#delete() or getNext() throws a DatabaseException.", e);
            }
        }
    }
}

