/*
 * Decompiled with CFR 0.152.
 */
package ow.directory;

import java.security.NoSuchProviderException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.directory.DirectoryProvider;
import ow.directory.berkeleydb.BerkeleyDBProvider;
import ow.directory.hashmap.PersistentMapProvider;
import ow.directory.hashmap.VolatileMapProvider;

public class DirectoryFactory {
    private static final Logger logger = Logger.getLogger("map");
    private static final Class[] PROVIDERS = new Class[]{BerkeleyDBProvider.class, PersistentMapProvider.class, VolatileMapProvider.class};
    private static final HashMap<String, DirectoryProvider> providerTable = new HashMap();

    public static DirectoryProvider getProvider(String providerName) throws NoSuchProviderException {
        DirectoryProvider provider = providerTable.get(providerName);
        if (provider == null) {
            throw new NoSuchProviderException("No such provider: " + providerName);
        }
        return provider;
    }

    static {
        for (Class clazz : PROVIDERS) {
            Object o;
            try {
                o = clazz.newInstance();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not instantiate an object of the class: " + clazz, e);
                continue;
            }
            if (!(o instanceof DirectoryProvider)) continue;
            DirectoryProvider provider = (DirectoryProvider)o;
            providerTable.put(provider.getName(), provider);
        }
    }
}

