/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.parser;

import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.header.Contact;
import gov.nist.javax.sip.header.ContactList;
import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.parser.AddressParametersParser;
import gov.nist.javax.sip.parser.Lexer;
import java.text.ParseException;
import java.util.Iterator;
import javax.sip.address.URI;

public class ContactParser
extends AddressParametersParser {
    public ContactParser(String contact) {
        super(contact);
    }

    protected ContactParser(Lexer lexer) {
        super(lexer);
        this.lexer = lexer;
    }

    public SIPHeader parse() throws ParseException {
        this.headerName(2087);
        ContactList retval = new ContactList();
        while (true) {
            Contact contact = new Contact();
            if (this.lexer.lookAhead(0) == '*') {
                char next = this.lexer.lookAhead(1);
                if (next == ' ' || next == '\t' || next == '\r' || next == '\n') {
                    this.lexer.match(42);
                    contact.setWildCardFlag(true);
                } else {
                    super.parse(contact);
                }
            } else {
                super.parse(contact);
            }
            AddressImpl address = (AddressImpl)contact.getAddress();
            URI uri = contact.getAddress().getURI();
            if (address.getAddressType() == 2 && uri instanceof SipUri) {
                SipUri sipUri = (SipUri)uri;
                Iterator it = sipUri.getParameterNames();
                while (it.hasNext()) {
                    String name = (String)it.next();
                    String val = sipUri.getParameter(name);
                    sipUri.removeParameter(name);
                    contact.setParameter(name, val);
                }
            }
            retval.add(contact);
            this.lexer.SPorHT();
            if (this.lexer.lookAhead(0) != ',') break;
            this.lexer.match(44);
            this.lexer.SPorHT();
        }
        if (this.lexer.lookAhead(0) != '\n' && this.lexer.lookAhead(0) != '\u0000') {
            throw this.createParseException("unexpected char");
        }
        return retval;
    }
}

