/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header.ims;

import gov.nist.core.NameValue;
import gov.nist.javax.sip.header.ParametersHeader;
import gov.nist.javax.sip.header.ims.ChargingFunctionAddressesHeader;
import gov.nist.javax.sip.header.ims.SIPHeaderNamesIms;
import java.text.ParseException;
import java.util.ListIterator;
import javax.sip.header.ExtensionHeader;

public class ChargingFunctionAddresses
extends ParametersHeader
implements ChargingFunctionAddressesHeader,
SIPHeaderNamesIms,
ExtensionHeader {
    public ChargingFunctionAddresses() {
        super("P-Charging-Function-Addresses");
    }

    protected String encodeBody() {
        StringBuffer encoding = new StringBuffer();
        if (!this.parameters.isEmpty()) {
            encoding.append(this.parameters.encode());
        }
        return encoding.toString();
    }

    public void setChargingCollectionFunctionAddress(String ccfAddress) throws ParseException {
        if (ccfAddress == null) {
            throw new NullPointerException("JAIN-SIP Exception, P-Charging-Function-Addresses, setChargingCollectionFunctionAddress(), the ccfAddress parameter is null.");
        }
        this.setParameter("ccf", ccfAddress);
    }

    public void addChargingCollectionFunctionAddress(String ccfAddress) throws Exception {
        if (ccfAddress == null) {
            throw new NullPointerException("JAIN-SIP Exception, P-Charging-Function-Addresses, setChargingCollectionFunctionAddress(), the ccfAddress parameter is null.");
        }
        this.parameters.add("ccf", ccfAddress);
    }

    public void removeChargingCollectionFunctionAddress(String ccfAddress) throws Exception {
        if (ccfAddress == null) {
            throw new NullPointerException("JAIN-SIP Exception, P-Charging-Function-Addresses, setChargingCollectionFunctionAddress(), the ccfAddress parameter is null.");
        }
        if (!this.delete(ccfAddress, "ccf")) {
            throw new Exception("CCF Address Not Removed");
        }
    }

    public ListIterator getChargingCollectionFunctionAddresses() {
        ListIterator li = this.parameters.listIterator();
        ListIterator ccfLIST = null;
        boolean removed = false;
        while (li.hasNext()) {
            NameValue nv = (NameValue)li.next();
            if (!nv.getName().equalsIgnoreCase("ccf")) continue;
            NameValue ccfNV = new NameValue();
            ccfNV.setName(nv.getName());
            ccfNV.setValue(nv.getValue());
            ccfLIST.add(ccfNV);
        }
        return ccfLIST;
    }

    public void setEventChargingFunctionAddress(String ecfAddress) throws ParseException {
        if (ecfAddress == null) {
            throw new NullPointerException("JAIN-SIP Exception, P-Charging-Function-Addresses, setEventChargingFunctionAddress(), the ecfAddress parameter is null.");
        }
        this.setParameter("ecf", ecfAddress);
    }

    public void addEventChargingFunctionAddress(String ecfAddress) throws ParseException {
        if (ecfAddress == null) {
            throw new NullPointerException("JAIN-SIP Exception, P-Charging-Function-Addresses, setEventChargingFunctionAddress(), the ecfAddress parameter is null.");
        }
        this.parameters.add("ecf", ecfAddress);
    }

    public void removeEventChargingFunctionAddress(String ecfAddress) throws ParseException {
        if (ecfAddress == null) {
            throw new NullPointerException("JAIN-SIP Exception, P-Charging-Function-Addresses, setEventChargingFunctionAddress(), the ecfAddress parameter is null.");
        }
        if (!this.delete(ecfAddress, "ecf")) {
            throw new ParseException("CCF Address Not Removed", 0);
        }
    }

    public ListIterator getEventChargingFunctionAddresses() {
        ListIterator li = this.parameters.listIterator();
        ListIterator ecfLIST = null;
        boolean removed = false;
        while (li.hasNext()) {
            NameValue nv = (NameValue)li.next();
            if (!nv.getName().equalsIgnoreCase("ecf")) continue;
            NameValue ecfNV = new NameValue();
            ecfNV.setName(nv.getName());
            ecfNV.setValue(nv.getValue());
            ecfLIST.add(ecfNV);
        }
        return ecfLIST;
    }

    public boolean delete(String value, String name) {
        ListIterator li = this.parameters.listIterator();
        boolean removed = false;
        while (li.hasNext()) {
            NameValue nv = (NameValue)li.next();
            if (!((String)nv.getValue()).equalsIgnoreCase(value) || !nv.getName().equalsIgnoreCase(name)) continue;
            li.remove();
            removed = true;
        }
        return removed;
    }

    public void setValue(String value) throws ParseException {
        throw new ParseException(value, 0);
    }
}

