/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import gov.nist.core.GenericObject;
import gov.nist.core.GenericObjectList;
import gov.nist.core.NameValue;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public class NameValueList
extends GenericObjectList {
    public NameValueList(String listName) {
        super(listName, NameValue.class);
    }

    public void add(NameValue nv) {
        if (nv == null) {
            throw new NullPointerException("null nv");
        }
        super.add(nv);
    }

    public void set(NameValue nv) {
        this.delete(nv.name);
        this.add(nv);
    }

    public void set(String name, Object value) {
        NameValue nv = new NameValue(name, value);
        this.set(nv);
    }

    public void add(String name, Object obj) {
        NameValue nv = new NameValue(name, obj);
        this.add(nv);
    }

    public boolean equals(Object otherObject) {
        if (!otherObject.getClass().equals(this.getClass())) {
            return false;
        }
        NameValueList other = (NameValueList)otherObject;
        if (this.size() != other.size()) {
            return false;
        }
        ListIterator li = this.listIterator();
        while (li.hasNext()) {
            NameValue nv = (NameValue)li.next();
            boolean found = false;
            ListIterator li1 = other.listIterator();
            while (li1.hasNext()) {
                NameValue nv1 = (NameValue)li1.next();
                if (!nv.equals(nv1)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public Object getValue(String name) {
        NameValue nv = this.getNameValue(name);
        if (nv != null) {
            return nv.value;
        }
        return null;
    }

    public NameValue getNameValue(String name) {
        ListIterator li = this.listIterator();
        NameValue retval = null;
        while (li.hasNext()) {
            NameValue nv = (NameValue)li.next();
            if (!nv.getName().equalsIgnoreCase(name)) continue;
            retval = nv;
            break;
        }
        return retval;
    }

    public boolean hasNameValue(String name) {
        return this.getNameValue(name) != null;
    }

    public boolean delete(String name) {
        ListIterator li = this.listIterator();
        boolean removed = false;
        while (li.hasNext()) {
            NameValue nv = (NameValue)li.next();
            if (!nv.getName().equalsIgnoreCase(name)) continue;
            li.remove();
            removed = true;
        }
        return removed;
    }

    public Iterator getNames() {
        LinkedList<String> ll = new LinkedList<String>();
        Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            String name = ((NameValue)iterator.next()).name;
            ll.add(name);
        }
        return ll.listIterator();
    }

    public NameValueList() {
    }

    public String getParameter(String name) {
        Object val = this.getValue(name);
        if (val == null) {
            return null;
        }
        if (val instanceof GenericObject) {
            return ((GenericObject)val).encode();
        }
        return val.toString();
    }
}

