/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.entity.test;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.ac.naka.ec.EntityCollaborator;
import jp.ac.naka.ec.entity.AbstractEntity;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityType;
import jp.ac.naka.ec.entity.test.MessageDumperEntity;

public class SliderEntity
extends AbstractEntity {
    JLabel label;

    public SliderEntity() {
        this.setEntityType(EntityType.SENSOR);
        JFrame frame = new JFrame("Slider");
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        frame.add(panel);
        JSlider slider = new JSlider(0, 100, 50);
        slider.addChangeListener(new MyListener());
        this.label = new JLabel("Value : 50");
        panel.add((Component)slider, "Center");
        panel.add((Component)this.label, "North");
        frame.pack();
        frame.setVisible(true);
    }

    public void receiveMessage(EntityEvent arg0) {
    }

    public static void main(String[] args) {
        try {
            EntityCollaborator ec = EntityCollaborator.getInstance();
            ec.initiateSipCore(5060);
            ec.initiateDHT();
            ec.addEntity(new SliderEntity());
            ec.addEntity(new MessageDumperEntity());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class MyListener
    implements ChangeListener {
        int prev = 50;

        private MyListener() {
        }

        public void stateChanged(ChangeEvent evt) {
            JSlider slider = (JSlider)evt.getSource();
            int value = slider.getValue();
            SliderEntity.this.label.setText("Value : " + value);
            if (Math.abs(this.prev - value) > 10) {
                SliderEntity.this.sendMessage("value:" + value);
                this.prev = value;
            }
        }
    }
}

