/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.entity.test;

import java.awt.GridLayout;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.media.Manager;
import javax.media.Player;
import javax.sdp.SessionDescription;
import javax.swing.JFrame;
import jp.ac.naka.ec.EntityCollaborator;
import jp.ac.naka.ec.entity.AbstractEntity;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityType;
import jp.ac.naka.ec.media.AudioPlayer;

public class AudioTransmitterEntity
extends AbstractEntity {
    Entity caller;
    AudioPlayer ap = new AudioPlayer();
    String user = "transmitter";
    String path;
    int port = 22225;
    JFrame jf;

    public AudioTransmitterEntity() {
        this.setEntityType(EntityType.MEDIA_TRANSMITTER);
        this.addKeyword("audio_transmitter");
        this.addKeyword("205");
        File file = new File("media/B5_01002.AIF");
        try {
            this.path = file.toURL().toString();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public void receiveMessage(EntityEvent e) {
    }

    public SessionDescription receiveOffer(EntityEvent evt) {
        if (this.caller != null) {
            return null;
        }
        this.caller = (Entity)evt.getSource();
        SessionDescription sdp = evt.getSessionDescription();
        SessionDescription temp = null;
        this.playSound();
        try {
            temp = this.ap.getResponseSessionDescription(this.user, this.port, sdp);
            this.ap.sendMediaStream(this.path, sdp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Thread th = new Thread(){

            public void run() {
                try {
                    AudioTransmitterEntity.this.ap.receiveMediaStream(AudioTransmitterEntity.this.port);
                    AudioTransmitterEntity.this.showController();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        th.start();
        return temp;
    }

    private void playSound() {
        File file = new File("media/m-phone1.wav");
        try {
            URL url = file.toURL();
            Player player = Manager.createRealizedPlayer((URL)url);
            player.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showController() {
        this.jf = new JFrame("controller");
        this.jf.setLayout(new GridLayout(2, 0));
        this.jf.add(this.ap.getTransmitterController());
        this.jf.add(this.ap.getReceiverController());
        this.jf.pack();
        this.jf.setVisible(true);
    }

    public void receiveBye(EntityEvent e) {
        if (this.ap.isPlaying()) {
            this.ap.stopReceivingMediaStream();
        }
        this.ap.stopSendingMediaStream();
        System.out.println("bye");
        this.caller = null;
        this.jf.setVisible(false);
        this.jf = null;
    }

    public static void main(String[] args) {
        EntityCollaborator ec = EntityCollaborator.getInstance();
        try {
            ec.initiateSipCore();
            ec.initiateDHT();
            ec.addEntity(new AudioTransmitterEntity());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

