/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.ac.naka.ec;

/**
 * Represent location
 * @author Takashi Kasuya
 *
 */
public class Location {

	private String name;
	private String latitude;
	private String longitude;
	private String floor;
	private long timestamp;
	
	public String getFloor() {
		return floor;
	}
	public void setFloor(String floor) {
		this.floor = floor;
	}
	public void setLatitude(String latitude) {
		this.latitude = latitude;
	}
	public void setLongitude(String longitude) {
		this.longitude = longitude;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Location(String lati, String lon) {
		this.latitude = lati;
		this.longitude = lon;
	}
	/**
	 * 
	 */
	public Location(String name, String lati, String lon) {
		this.name = name;
		this.latitude = lati;
		this.longitude = lon;
	}

	public Location() {
	}
	/**
	 * GeoCodeŎꏊ̖
	 * @return
	 */
	public String getName() {
		return name;
	}
	
	/**
	 * ܓx̎擾
	 * @return
	 */
	public String getLatitude() {
		return latitude;
	}

	/**
	 * ox̎擾
	 * @return
	 */
	public String getLongitude() {
		return longitude;
	}
	
	
	@Override
	public boolean equals(Object obj) {
		if (obj instanceof Location) {
			Location l = (Location)obj;
			if(l.getLatitude().equals(latitude) && l.getLongitude().equals(longitude)) {
				if (l.getName() != null) 
					return l.getName().equals(name);
				else 
					return true;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
	public String toXML(String padding) {
		StringBuilder sb = new StringBuilder();
		sb.append(padding);
		if (name != null) {
			sb.append("<location name=\"");
			sb.append(getName());
			sb.append("\" latitude=\"");
		} else {
			sb.append("<location latitude=\"");
		}
		sb.append(getLatitude());
		sb.append("\" longitude=\"");
		sb.append(getLongitude());
		sb.append("\" />\r\n");
		return sb.toString();
	}
	public long getTimestamp() {
		return timestamp;
	}
	public void setTimestamp(long timestamp) {
		this.timestamp = timestamp;
	}
	

}
