/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.ac.naka.ec.sip;

import javax.sdp.SdpFactory;
import javax.sdp.SessionDescription;
import javax.sip.RequestEvent;
import javax.sip.ServerTransaction;
import javax.sip.address.SipURI;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.ac.naka.ec.entity.AbstractEntity;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityContainerImpl;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityImpl;


/**
 * @author Takashi Kasuya
 * 
 */
class InviteDelegate implements MethodDelegate {

	private static Log logger = LogFactory.getLog(InviteDelegate.class);
	private static SipCore core;
	private static SdpFactory factory = SdpFactory.getInstance();
	private static EntityContainer container;
	private Callback callback = new Callback();
	
	public InviteDelegate() {
		core = SipCore.getInstance();
		container = EntityContainerImpl.getInstance();
	}

	public boolean forward(RequestEvent evt) {
		Request req = evt.getRequest();

		ContentTypeHeader type = (ContentTypeHeader) req
				.getHeader(ContentTypeHeader.NAME);
		FromHeader from = (FromHeader) req.getHeader(FromHeader.NAME);

		if (type.getContentType().equals("application")
				&& type.getContentSubType().equals("sdp")) {
			try {
				byte[] raw = req.getRawContent();
				if (isMidRequest(evt)) {
					// TODO
					core.sendResponse(Response.SERVER_INTERNAL_ERROR, evt, from
							.getAddress().getURI().toString());
					return false;
				}
				SessionDescription sdp = null;

				if (raw != null) {
					String sdp_str = new String(raw, "UTF-8");
					sdp = factory.createSessionDescription(sdp_str);
				}
				ToHeader to = (ToHeader) req.getHeader(ToHeader.NAME);
				SipURI targetURI = (SipURI) to.getAddress().getURI();
				SipURI sourceURI = (SipURI) from.getAddress().getURI();

				Entity target = container.getEntity(targetURI.toString());
				if (target == null) {
					// Error
					core.sendResponse(Response.NOT_FOUND, req);
					return false;
				}
				Entity source = new EntityImpl(sourceURI);
				source.setLocal(false);
				
				core.sendResponse(Response.TRYING, evt, sourceURI.toString());
				EntityEvent e = new EntityEvent(sdp, target, source);
				e.setRequest(req);
				
				if (((AbstractEntity)target).getCallback() == null) {
					((AbstractEntity)target).setCallback(callback);
				}
				((AbstractEntity)target).handleEvent(e);
			} catch (Exception e) {
				logger.warn("Error while processing SDP.", e);
				try {
					core.sendResponse(Response.SERVER_INTERNAL_ERROR, evt, from
							.getAddress().getURI().toString());
				} catch (Exception e1) {
					logger.warn("Cannot send a error Response.", e);
				}
				return false;
			}
		} else {
			logger.warn("Unsuported Content-Type: +" + type.toString());
			return false;
		}
		return true;
	}

	private boolean isMidRequest(RequestEvent evt) {
		ServerTransaction st = evt.getServerTransaction();
		return (st != null) ? true : false;
	}

	public class Callback implements InviteCallback {

		
		public void receiveAnswer(SessionDescription sdp, EntityEvent evt) {
			if (sdp == null) {
				//TODO Error
				try {
					core.sendResponse(Response.NOT_ACCEPTABLE_HERE, evt.getRequest());
					return;
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
			Request req = evt.getRequest();
			Entity source = (Entity)evt.getTarget();
			Entity target = (Entity)evt.getSource();
			core.sendResponse(sdp, req, target.getURI(), source.getURI());
		}

		
	}
}
