/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.ac.naka.ec.sip;

import javax.sip.RequestEvent;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.header.FromHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;

import jp.ac.naka.ec.EventDispatcher;
import jp.ac.naka.ec.entity.AbstractEntity;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityContainerImpl;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityEventDispatcher;
import jp.ac.naka.ec.entity.EntityImpl;
import jp.ac.naka.ec.entity.EntityEvent.EventType;

import org.apache.log4j.Logger;

/**
 * @author Takashi Kasuya
 * 
 */
class ByeDelegate implements MethodDelegate {

	private static Logger logger = Logger.getLogger(ByeDelegate.class);
	private static SipCore core;
	private static EntityContainer container;
	public ByeDelegate() {
		core = SipCore.getInstance();
		container = EntityContainerImpl.getInstance();
	}

	public boolean forward(RequestEvent evt) {
		Request req = evt.getRequest();
		FromHeader from = (FromHeader) req
				.getHeader(FromHeader.NAME);
		Address addr = from.getAddress();

		try {

			ToHeader to = (ToHeader) req.getHeader(ToHeader.NAME);
			SipURI targetURI = (SipURI) to.getAddress().getURI();
			Entity target = container.getEntity(targetURI.toString());
			SipURI sourceURI = (SipURI) from.getAddress().getURI();
			Entity source = new EntityImpl(sourceURI);
			// 200 OK
			core.sendResponse(Response.OK, evt, sourceURI.toString());
			EntityEvent ee = new EntityEvent(target, source, EventType.BYE);
			((AbstractEntity)target).handleEvent(ee);
		} catch (Exception e) {
			logger.warn("Error while processing SDP.", e);
			try {
				core.sendResponse(Response.SERVER_INTERNAL_ERROR, evt, addr
						.getURI().toString());
			} catch (Exception e1) {
				logger.warn("Cannot send a error Response.", e);
			}
			return false;
		}

		return true;
	}

}
