/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.ac.naka.ec.entity.test;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Set;

import javax.media.MediaException;
import javax.sdp.SdpException;
import javax.sdp.SessionDescription;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

import jp.ac.naka.ec.EntityCollaborator;
import jp.ac.naka.ec.dht.Chord;
import jp.ac.naka.ec.entity.AbstractEntity;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityImpl;
import jp.ac.naka.ec.entity.EntityType;
import jp.ac.naka.ec.media.MediaListener;
import jp.ac.naka.ec.media.MediaReceiveEvent;
import jp.ac.naka.ec.media.MediaReceiver;
import jp.ac.naka.ec.sip.SipCore;

/**
 * {^ƁAlbg[NrfI\[XāAZbV𒣂̂\B
 * 
 * @author Takashi Kasuya
 * 
 */
public class VideoReceiverEntity extends AbstractEntity implements
		MediaListener {

	MediaReceiver receiver;

	ButtonFrame button;

	Entity callee;

	@Override
	public void init() {
		// setName("VideoReceiver");
		setEntityType(EntityType.MEDIA_RECEIVER);
		receiver = new MediaReceiver();
		receiver.addMediaListener(this);
		button = new ButtonFrame("MediaSender");
	}

	@Override
	public void receiveMessage(EntityEvent e) {
	}

	@Override
	public void receiveAnswer(EntityEvent evt) {
		SessionDescription sdp = evt.getSessionDescription();
		try {
			System.out.println(sdp.toString());
			receiver.receiveMedia(sdp);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private void requestMedia() {
		if (callee != null)
			return;
		EntityContainer con = getContainer();
		Entity[] set = null;
		SessionDescription sdp = null;
		set = con.searchEntities("camera");
		try {
			sdp = receiver.getRequestSessionDescription();
		} catch (UnknownHostException e) {
			e.printStackTrace();
		} catch (SdpException e) {
			e.printStackTrace();
		}
		for (Entity entity : set) {
			// TransmitterTăjLXg
			if (entity.getEntityType() == EntityType.MEDIA_TRANSMITTER) {
				sendOffer(sdp, entity);
				callee = entity;
				break;
			}
		}
	}

	private class ButtonFrame extends JFrame {
		JButton jb = new JButton("Request Media!");

		JButton bye = new JButton("BYE");

		JPanel panel = new JPanel();

		public ButtonFrame(String name) {
			super(name);
			panel.add(jb);
			panel.add(bye);
			setLayout(new GridLayout(2, 1));
			jb.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					requestMedia();
				}

			});

			bye.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (callee != null)
						sendBye(callee);
				}
			});
			add(panel, 0);
			pack();
			this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
			setVisible(true);
		}
	}

	JFrame prev;

	public void receiveMedia(MediaReceiveEvent e) {
		System.out.println("start");
		prev = new JFrame("movie");
		JPanel panel = new JPanel();
		Component comp = receiver.getVisualComponent();
		panel.setPreferredSize(comp.getPreferredSize());
		panel.add(comp);
		prev.add(panel);
		prev.pack();
		prev.setVisible(true);
	}

	public void terminateMedia(MediaReceiveEvent e) {
		System.out.println("end");
		prev.remove(0);
		prev.setVisible(false);
		// button.remove(prev);
	}
	
	public static void main(String[] args) {
		
	}
}
