/*
 *  Copyright (C) 2007  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.ac.naka.ec;

import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.TooManyListenersException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import javax.sip.InvalidArgumentException;
import javax.sip.SipException;

import jp.ac.naka.ec.dht.Chord;
import jp.ac.naka.ec.dht.FindPeer;
import jp.ac.naka.ec.dht.LookupEvent;
import jp.ac.naka.ec.dht.LookupListener;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityConfigParser;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityContainerImpl;
import jp.ac.naka.ec.sip.SipCore;

import org.apache.log4j.PropertyConfigurator;

public class EntityCollaborator{

	private EntityContainer container;
	private static Chord chord;
	private static EntityCollaborator instance = new EntityCollaborator();
	public static int PORT = 5060;
	public static String base = ".";
	public static FindPeer fp;
	private List<Entity> tempEntities;
	
	private EntityCollaborator() {
	}

	
	/**
	 * 
	 * @return entities ێĂEntity̐
	 */
	public Entity[] getEntities() {
		return container.getEntities();
	}

	/**
	 * ftHg
	 * 
	 * @return
	 * @throws Exception
	 */
	public static EntityCollaborator getInstance() {
		// AutoConfig
		instance.container = EntityContainerImpl.getInstance();
		return instance;
	}

	/**
	 * lbg[NC^tF[Xw肳ꂽꍇ
	 * @param ni(Network Interface)
	 * @return
	 * @throws ParseException 
	 * @throws IOException 
	 */
	public static EntityCollaborator getInstance(String ni) throws IOException, ParseException {
		// w肳ꂽC^tF[XIPAhX擾
		instance.container = EntityContainerImpl.getInstance(ni);
		return instance;
	}
	
	public boolean addEntity(Entity e1) {
		container.addEntity(e1);
		if (chord != null) {
			try {
				boolean ret = chord.insertEntity(e1);
				//boolean ret = false;
				return ret;
			} catch (Exception e) {
				e.printStackTrace();
				return false;
			}
		} else {
			if (tempEntities == null)
				tempEntities = new ArrayList<Entity>();
			tempEntities.add(e1);
		}
		return true;
	}

	public Entity[] searchEntities(String keyword) {
		if (chord != null)
			return container.searchEntities(keyword);
		else
			throw new NullPointerException("DHT is not initialized");
	}

	public void initiateDHT() throws Exception {
		chord = Chord.getInstance();
		chord.init();
	}

	public void initiateDHT(String bootstrapURI) throws Exception {
		chord = Chord.getInstance();
		chord.init(bootstrapURI, Chord.PORT);
	}

	public void initiateDHT(String bootstrapURI, int port) throws Exception {
		chord = Chord.getInstance();
		chord.init(bootstrapURI, port);
	}

	public Entity getEntity(String uri) {
		Entity ret = container.getEntity(uri);
		return ret;
	}

	public void initiateSipCore() throws IOException, SipException, ParseException, InvalidArgumentException, TooManyListenersException {
		SipCore core = SipCore.getInstance();
		String hostname = EntityContainerImpl.getIpAddress(EntityContainerImpl.getHostName());
		core.initialize(hostname, SipCore.PORT);
	}

	public void findPeer() throws IOException {
		fp = FindPeer.getInstance();
		fp.addLookupListener(new LookupListener() {
			public void findPeer(LookupEvent evt) {
				System.out.println("Peer Found :" + evt.getPeerAddress().getHostAddress());
				InetAddress addr = evt.getPeerAddress();
				try {
					initiateDHT(addr.getHostAddress());
					for (Entity entity:tempEntities)
						chord.insertEntity(entity);
					tempEntities.clear();
					tempEntities = null;
				} catch (Exception e) {
					e.printStackTrace();
				}
			}

			public void peerNotFound(LookupEvent evt) {
				try {
					System.out.println("Peer Not Found.");
					initiateDHT();
					for (Entity entity:tempEntities)
						chord.insertEntity(entity);
					tempEntities.clear();
					tempEntities = null;
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
		fp.findOtherPeer();
		ExecutorService service = Executors.newSingleThreadExecutor();
		service.execute(fp);
	}
	
	public static String config = "./config/entities.xml";
	
	public void initEntities() {
		EntityConfigParser parser = new EntityConfigParser();
		Entity[] entities = parser.parse(config);
		for (Entity entity:entities) {
			System.out.println("add " + entity.getName() );
			addEntity(entity);
		}
	}
	
}
