/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.media;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaException;
import javax.media.MediaLocator;
import javax.media.NoDataSourceException;
import javax.media.Processor;
import javax.media.control.FormatControl;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.sdp.Connection;
import javax.sdp.Media;
import javax.sdp.MediaDescription;
import javax.sdp.SdpException;
import javax.sdp.SessionDescription;
import javax.swing.JButton;
import javax.swing.JFrame;
import jp.ac.naka.ec.media.DeviceInfo;
import jp.ac.naka.ec.media.SDPGenerator;
import jp.ac.naka.ec.media.SessionInformation;
import jp.ac.naka.ec.media.WaitingListener;

public class MediaTransmitter {
    protected int[] receivableJmfVideoFormats = new int[]{34, 26, 31};
    protected int[] receivableJmfAudioFormats;
    List<Integer> availableVideoFormats;
    List<Integer> availableAudioFormats;
    private Processor audio_processor;
    private Processor video_processor;
    private DataSink audio_ds;
    private DataSink video_ds;
    private static boolean debugDeviceList = true;
    public static String defaultVideoDeviceName = "vfw:Microsoft WDM Image Capture (Win32):0";
    public static String defaultAudioDeviceName = "DirectSoundCapture";
    public static String defaultVideoFormatString = "size=352x288, encoding=yuv, maxdatalength=152064";
    public static String defaultAudioFormatString = "linear, 8000.0 hz, 8-bit, mono, unsigned";
    private static CaptureDeviceInfo captureVideoDevice = null;
    private static CaptureDeviceInfo captureAudioDevice = null;
    private VideoFormat captureVideoFormat;
    private AudioFormat captureAudioFormat;
    private boolean enable_audio;
    private int audio_port;
    private int video_port;
    private WaitingListener listener;
    SessionInformation[] info;

    public MediaTransmitter() {
        int format;
        int[] nArray = new int[7];
        nArray[0] = 4;
        nArray[1] = 3;
        nArray[3] = 5;
        nArray[4] = 6;
        nArray[5] = 8;
        nArray[6] = 15;
        this.receivableJmfAudioFormats = nArray;
        this.availableVideoFormats = new ArrayList<Integer>();
        this.availableAudioFormats = new ArrayList<Integer>();
        this.captureVideoFormat = null;
        this.captureAudioFormat = null;
        this.enable_audio = true;
        this.audio_port = 22222;
        this.video_port = 44444;
        this.listener = new WaitingListener();
        Arrays.sort(this.receivableJmfVideoFormats);
        int[] nArray2 = this.receivableJmfVideoFormats;
        int n = 0;
        int n2 = nArray2.length;
        while (n < n2) {
            format = nArray2[n];
            this.availableVideoFormats.add(format);
            ++n;
        }
        Arrays.sort(this.receivableJmfAudioFormats);
        nArray2 = this.receivableJmfAudioFormats;
        n = 0;
        n2 = nArray2.length;
        while (n < n2) {
            format = nArray2[n];
            this.availableAudioFormats.add(format);
            ++n;
        }
    }

    public void enableAudio(boolean a) {
        this.enable_audio = a;
    }

    public void sendMedia(String host) throws MediaException, IOException, SdpException {
        List<Integer> audio = null;
        if (this.enable_audio) {
            audio = this.availableAudioFormats;
        }
        SessionDescription sdp = SDPGenerator.getRequestSessionDescription(0, "media_sender", "-", host, audio, this.audio_port, this.availableVideoFormats, this.video_port);
        this.sendMedia(sdp);
    }

    public void sendMedia(SessionDescription sdp) throws MediaException, IOException, SdpException {
        Connection c = sdp.getConnection();
        InetAddress addr = InetAddress.getByName(c.getAddress());
        Vector mds = sdp.getMediaDescriptions(true);
        this.info = new SessionInformation[mds.size()];
        int i = 0;
        for (MediaDescription md : mds) {
            Media media = md.getMedia();
            Vector formats = media.getMediaFormats(true);
            int payload = Integer.parseInt((String)formats.get(0));
            int port = media.getMediaPort();
            this.info[i] = new SessionInformation(addr.getHostAddress(), port);
            Format format = SDPGenerator.findCorrespondingFormat(payload);
            if (format == null) continue;
            this.info[i].format = format;
            ++i;
        }
        this.initialize(this.info);
        this.play();
    }

    private void initialize(SessionInformation[] info) throws MediaException, IOException {
        this.setUpCaptureDevice();
        int i = 0;
        while (i < info.length) {
            this.setUpDataSource(info[i]);
            this.setUpProcessor(info[i]);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUpProcessor(SessionInformation info) throws IOException, MediaException {
        String media = info.getMediaType();
        Processor p = null;
        if (!DeviceInfo.setFormat(info.ds, info.capture_format) && info.capture_format != null) {
            throw new MediaException("Invalid format : " + info.capture_format.toString());
        }
        p = Manager.createProcessor((DataSource)info.ds);
        if (media.equals("video")) {
            this.video_processor = p;
        } else {
            this.audio_processor = p;
        }
        p.addControllerListener((ControllerListener)this.listener);
        p.configure();
        WaitingListener waitingListener = this.listener;
        synchronized (waitingListener) {
            this.listener.waitForEvent(180);
        }
        p.setContentDescriptor(new ContentDescriptor("raw"));
        TrackControl[] track = p.getTrackControls();
        boolean encodingOk = false;
        int i2 = 0;
        while (i2 < track.length) {
            if (!encodingOk && track[i2] instanceof FormatControl) {
                TrackControl control = track[i2];
                if (control.setFormat(info.format) == null) {
                    track[i2].setEnabled(false);
                } else {
                    encodingOk = true;
                }
            } else {
                track[i2].setEnabled(false);
            }
            ++i2;
        }
        if (encodingOk) {
            p.realize();
            WaitingListener i2 = this.listener;
            synchronized (i2) {
                this.listener.waitForEvent(300);
            }
            DataSource ds = null;
            ds = p.getDataOutput();
            try {
                MediaLocator ml = new MediaLocator("rtp://" + info.addr + ":" + info.port + "/" + media + "/" + info.ttl);
                DataSink d = Manager.createDataSink((DataSource)ds, (MediaLocator)ml);
                if (media.equals("video")) {
                    this.video_ds = d;
                } else {
                    this.audio_ds = d;
                }
            }
            catch (Exception e) {
                throw new MediaException(e.getMessage());
            }
        }
    }

    private void setUpDataSource(SessionInformation info) throws NoDataSourceException, IOException {
        String media;
        String string = media = info.format instanceof VideoFormat ? "video" : "audio";
        if (media.equals("video") && captureVideoDevice != null) {
            DataSource ds;
            info.ds = ds = Manager.createDataSource((MediaLocator)captureVideoDevice.getLocator());
            info.device = captureVideoDevice;
            if (this.captureVideoFormat != null) {
                info.capture_format = this.captureVideoFormat;
            }
        } else if (media.equals("audio") && captureAudioDevice != null) {
            DataSource ds;
            info.ds = ds = Manager.createDataSource((MediaLocator)captureAudioDevice.getLocator());
            info.device = captureAudioDevice;
            if (this.captureAudioFormat != null) {
                info.capture_format = this.captureAudioFormat;
            }
        } else {
            throw new NullPointerException("Processor is null");
        }
    }

    private void setUpCaptureDevice() throws MediaException {
        Vector deviceListVector = CaptureDeviceManager.getDeviceList(null);
        if (deviceListVector == null || deviceListVector.size() == 0) {
            throw new MediaException("There is no available capture device.");
        }
        int i = 0;
        while (i < deviceListVector.size()) {
            CaptureDeviceInfo deviceInfo = (CaptureDeviceInfo)deviceListVector.elementAt(i);
            String deviceInfoText = deviceInfo.getName();
            if (debugDeviceList) {
                System.err.println("device " + i + ": " + deviceInfoText);
            }
            Format[] deviceFormat = deviceInfo.getFormats();
            int j = 0;
            while (j < deviceFormat.length) {
                Format format = deviceFormat[j];
                if (captureVideoDevice == null && format instanceof VideoFormat && (deviceInfo.getName().indexOf(defaultVideoDeviceName) >= 0 || defaultVideoDeviceName.equals(""))) {
                    captureVideoDevice = deviceInfo;
                    System.err.println(">>> capture video device = " + deviceInfo.getName());
                }
                if (captureVideoDevice == deviceInfo && this.captureVideoFormat == null && DeviceInfo.formatToString(format).indexOf(defaultVideoFormatString) >= 0) {
                    this.captureVideoFormat = (VideoFormat)format;
                    System.err.println(">>> capture video format = " + DeviceInfo.formatToString(deviceFormat[j]));
                }
                if (captureAudioDevice == null && format instanceof AudioFormat && (deviceInfo.getName().indexOf(defaultAudioDeviceName) >= 0 || defaultAudioDeviceName.equals(""))) {
                    captureAudioDevice = deviceInfo;
                    System.err.println(">>> capture audio device = " + deviceInfo.getName());
                }
                if (captureAudioDevice == deviceInfo && this.captureAudioFormat == null && DeviceInfo.formatToString(format).indexOf(defaultAudioFormatString) >= 0) {
                    this.captureAudioFormat = (AudioFormat)format;
                    System.err.println(">>> capture audio format = " + DeviceInfo.formatToString(deviceFormat[j]));
                    if (debugDeviceList) {
                        System.err.println(" - format: " + DeviceInfo.formatToString(format));
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public Component getControlPanelComponent() {
        if (this.video_processor != null) {
            return this.video_processor.getControlPanelComponent();
        }
        if (this.audio_processor != null) {
            return this.audio_processor.getControlPanelComponent();
        }
        return null;
    }

    public boolean isPlaying() {
        if (this.video_processor != null) {
            return this.video_processor.getState() == 600;
        }
        if (this.audio_processor != null) {
            return this.audio_processor.getState() == 600;
        }
        return false;
    }

    public void setNewSessionDescription(SessionDescription sdp) {
    }

    public void play() throws IOException {
        if (this.video_ds != null) {
            this.video_ds.open();
            this.video_ds.start();
            this.video_processor.start();
            System.out.println("Start Video Transmitting...");
        }
        if (this.audio_ds != null) {
            this.audio_ds.open();
            this.audio_ds.start();
            this.audio_processor.start();
            System.out.println("Start Audio Transmitting...");
        }
    }

    public void stop() throws IOException {
        if (this.video_ds != null) {
            this.video_processor.stop();
            this.video_ds.stop();
        }
        if (this.audio_ds != null) {
            this.audio_processor.stop();
            this.audio_ds.stop();
        }
    }

    public void close() {
        if (this.video_ds != null) {
            this.video_processor.close();
            this.video_ds.close();
        }
        if (this.audio_ds != null) {
            this.audio_processor.close();
            this.audio_ds.close();
        }
    }

    public void setAudioPort(int i) {
        this.video_port = i;
    }

    public void setVideoPort(int i) {
        this.audio_port = i;
    }

    public SessionDescription getResponseSessionDescription(SessionDescription sdp) throws UnknownHostException, SdpException {
        SessionDescription ret = null;
        ret = sdp != null ? SDPGenerator.getResponseSessionDescription(sdp) : this.getRequestSessionDescription();
        return ret;
    }

    public SessionDescription getRequestSessionDescription() throws UnknownHostException, SdpException {
        InetAddress addr = InetAddress.getLocalHost();
        List<Integer> audio = null;
        SessionDescription sdp = SDPGenerator.getRequestSessionDescription(0, "media_sender", "-", addr.getHostAddress(), audio, this.audio_port, this.availableVideoFormats, this.video_port);
        return sdp;
    }

    public static void main(String[] args) throws Exception {
        MediaTransmitter mt = new MediaTransmitter();
        mt.enableAudio(false);
        mt.sendMedia("localhost");
        mt.setVideoPort(44444);
        mt.setAudioPort(22222);
        JFrame jf = new JFrame("Test");
        jf.setLayout(new FlowLayout());
        JButton play = new JButton("play");
        play.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    MediaTransmitter.this.play();
                    System.out.println(MediaTransmitter.this.isPlaying());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        jf.add(play);
        JButton jb = new JButton("stop");
        jb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    MediaTransmitter.this.stop();
                    System.out.println(MediaTransmitter.this.isPlaying());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        jf.add(jb);
        JButton close = new JButton("close");
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MediaTransmitter.this.close();
                System.out.println(MediaTransmitter.this.isPlaying());
            }
        });
        jf.add(close);
        jf.pack();
        jf.setVisible(true);
        jf.setDefaultCloseOperation(3);
    }
}

