/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.media;

import java.awt.Component;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.media.MediaException;
import javax.media.NoDataSinkException;
import javax.media.NotRealizedError;
import javax.media.format.AudioFormat;
import javax.sdp.Connection;
import javax.sdp.Media;
import javax.sdp.MediaDescription;
import javax.sdp.SdpException;
import javax.sdp.SessionDescription;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.media.AudioReceiver;
import jp.ac.naka.ec.media.AudioTransmitter;
import jp.ac.naka.ec.media.SDPGenerator;

public class AudioPlayer {
    protected int srcPort = 22224;
    protected int limit = 3;
    private AudioReceiver receiver;
    private AudioTransmitter transmiter;
    protected List<Integer> availableAudioFormats = new ArrayList<Integer>();
    protected int[] receivableJmfAudioFormats;

    public AudioPlayer() {
        int[] nArray = new int[7];
        nArray[0] = 4;
        nArray[1] = 3;
        nArray[3] = 5;
        nArray[4] = 6;
        nArray[5] = 8;
        nArray[6] = 15;
        this.receivableJmfAudioFormats = nArray;
    }

    public AudioPlayer(int port) {
        int[] nArray = new int[7];
        nArray[0] = 4;
        nArray[1] = 3;
        nArray[3] = 5;
        nArray[4] = 6;
        nArray[5] = 8;
        nArray[6] = 15;
        this.receivableJmfAudioFormats = nArray;
        this.init();
        this.srcPort = port;
    }

    private void init() {
        Arrays.sort(this.receivableJmfAudioFormats);
        int[] nArray = this.receivableJmfAudioFormats;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int format = nArray[n];
            this.availableAudioFormats.add(format);
            ++n;
        }
    }

    public SessionDescription getRequestSessionDescription(Entity source) throws UnknownHostException, SdpException {
        return this.getRequestSessionDescription(0, source.getName(), "s");
    }

    public SessionDescription getRequestSessionDescription(int version, String userName, String sessionName) throws UnknownHostException, SdpException {
        InetAddress addr = InetAddress.getLocalHost();
        List<Integer> video = null;
        SessionDescription sdp = SDPGenerator.getRequestSessionDescription(0, "media_sender", "-", addr.getHostAddress(), this.availableAudioFormats, this.srcPort, video, 0);
        return sdp;
    }

    public SessionDescription getResponseSessionDescription(SessionDescription sdp) throws UnknownHostException, SdpException {
        SessionDescription ret = SDPGenerator.getResponseSessionDescription(sdp);
        return ret;
    }

    public static String getSessionDescriptionString(String sdp_file) throws FileNotFoundException, IOException {
        FileReader fr = new FileReader(sdp_file);
        BufferedReader br = new BufferedReader(fr);
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while ((i = br.read()) != -1) {
            char c = (char)i;
            builder.append(c);
        }
        return builder.toString();
    }

    public void addAvailableFormat(int payload) {
        this.availableAudioFormats.add(payload);
    }

    public void receiveMediaStream(SessionDescription sdp) throws MediaException, SdpException {
        if (this.receiver == null) {
            this.receiver = new AudioReceiver();
        }
        this.receiver.receiveMedia(sdp);
    }

    public void sendMediaStream(String path, int port) throws MediaException {
        if (this.transmiter == null) {
            this.transmiter = new AudioTransmitter(path, port);
        }
    }

    public boolean sendMediaStream(SessionDescription sdp) throws MediaException, IOException, SdpException {
        return this.sendMediaStream(null, sdp);
    }

    public boolean sendMediaStream(String path, SessionDescription sdp) throws MediaException, IOException, SdpException {
        Connection c = sdp.getConnection();
        InetAddress addr = InetAddress.getByName(c.getAddress());
        Vector mds = sdp.getMediaDescriptions(true);
        AudioFormat format = null;
        int port = this.srcPort;
        for (MediaDescription md : mds) {
            Media media = md.getMedia();
            Vector formats = media.getMediaFormats(true);
            int payload = Integer.parseInt((String)formats.get(0));
            port = media.getMediaPort();
            format = (AudioFormat)SDPGenerator.findCorrespondingFormat(payload);
            if (format == null) break;
        }
        if (format == null) {
            return false;
        }
        if (this.transmiter == null) {
            this.transmiter = new AudioTransmitter(path, addr.getHostAddress(), port, format);
        }
        this.transmiter.play();
        return true;
    }

    public void sendMediaStream(String dest_url, int port, String media) throws MediaException {
        if (this.transmiter == null) {
            this.transmiter = new AudioTransmitter(media, dest_url, port);
        }
    }

    public boolean stopReceivingMediaStream() {
        if (this.receiver != null) {
            this.receiver.stop();
            return true;
        }
        return false;
    }

    public boolean stopSendingMediaStream() {
        if (this.receiver != null) {
            this.transmiter.close();
            return true;
        }
        return false;
    }

    public boolean isPlaying() {
        if (this.receiver != null) {
            return this.receiver.isPlaying();
        }
        if (this.transmiter != null) {
            return this.transmiter.isPlaying();
        }
        return false;
    }

    public Component getTransmitterController() {
        return this.transmiter.getControlPanelComponent();
    }

    public Component getReceiverController() {
        return this.receiver.getControlPanelComponent();
    }

    public boolean isSending() {
        return this.transmiter.isPlaying();
    }

    public void setPort(int port) {
        this.srcPort = port;
    }

    public void store(String path) throws NoDataSinkException, NotRealizedError, SecurityException, IOException {
        this.receiver.store(path);
    }

    public static void main(String[] args) {
        AudioPlayer receiver = null;
        receiver = new AudioPlayer();
        try {
            InetAddress addr = InetAddress.getLocalHost();
            SessionDescription sdp = receiver.getRequestSessionDescription(0, "hoge", "-");
            receiver.receiveMediaStream(receiver.getResponseSessionDescription(sdp));
            Frame frame = new Frame("test");
            frame.pack();
            frame.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

