/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.entity.test;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.UnknownHostException;
import javax.sdp.SdpException;
import javax.sdp.SessionDescription;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import jp.ac.naka.ec.entity.AbstractEntity;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityType;
import jp.ac.naka.ec.media.MediaListener;
import jp.ac.naka.ec.media.MediaReceiveEvent;
import jp.ac.naka.ec.media.MediaReceiver;

public class VideoReceiverEntity
extends AbstractEntity
implements MediaListener {
    MediaReceiver receiver;
    ButtonFrame button;
    Entity callee;
    JFrame prev;

    public void init() {
        this.setEntityType(EntityType.MEDIA_RECEIVER);
        this.receiver = new MediaReceiver();
        this.receiver.addMediaListener(this);
        this.button = new ButtonFrame("MediaSender");
    }

    public void receiveMessage(EntityEvent e) {
    }

    public void receiveAnswer(EntityEvent evt) {
        SessionDescription sdp = evt.getSessionDescription();
        try {
            System.out.println(sdp.toString());
            this.receiver.receiveMedia(sdp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void requestMedia() {
        if (this.callee != null) {
            return;
        }
        EntityContainer con = this.getContainer();
        Entity[] set = null;
        SessionDescription sdp = null;
        set = con.searchEntities("camera");
        try {
            sdp = this.receiver.getRequestSessionDescription();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (SdpException e) {
            e.printStackTrace();
        }
        Entity[] entityArray = set;
        int n = 0;
        int n2 = entityArray.length;
        while (n < n2) {
            Entity entity = entityArray[n];
            if (entity.getEntityType() == EntityType.MEDIA_TRANSMITTER) {
                this.sendOffer(sdp, entity);
                this.callee = entity;
                break;
            }
            ++n;
        }
    }

    public void receiveMedia(MediaReceiveEvent e) {
        System.out.println("start");
        this.prev = new JFrame("movie");
        JPanel panel = new JPanel();
        Component comp = this.receiver.getVisualComponent();
        panel.setPreferredSize(comp.getPreferredSize());
        panel.add(comp);
        this.prev.add(panel);
        this.prev.pack();
        this.prev.setVisible(true);
    }

    public void terminateMedia(MediaReceiveEvent e) {
        System.out.println("end");
        this.prev.remove(0);
        this.prev.setVisible(false);
    }

    public static void main(String[] args) {
    }

    private class ButtonFrame
    extends JFrame {
        JButton jb;
        JButton bye;
        JPanel panel;

        public ButtonFrame(String name) {
            super(name);
            this.jb = new JButton("Request Media!");
            this.bye = new JButton("BYE");
            this.panel = new JPanel();
            this.panel.add(this.jb);
            this.panel.add(this.bye);
            this.setLayout(new GridLayout(2, 1));
            this.jb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    VideoReceiverEntity.this.requestMedia();
                }
            });
            this.bye.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (((ButtonFrame)ButtonFrame.this).VideoReceiverEntity.this.callee != null) {
                        VideoReceiverEntity.this.sendBye(((ButtonFrame)ButtonFrame.this).VideoReceiverEntity.this.callee);
                    }
                }
            });
            this.add((Component)this.panel, 0);
            this.pack();
            this.setDefaultCloseOperation(3);
            this.setVisible(true);
        }
    }
}

