/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.entity.test;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.sdp.SessionDescription;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import jp.ac.naka.ec.dht.Chord;
import jp.ac.naka.ec.entity.AbstractEntity;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.media.MediaListener;
import jp.ac.naka.ec.media.MediaReceiveEvent;
import jp.ac.naka.ec.media.MediaReceiver;
import jp.ac.naka.ec.sensor.SensorData;

public class SampleEntity
extends AbstractEntity
implements ActionListener,
MediaListener {
    JFrame frame;
    JTextField keyword;
    JTextField msgField;
    JList list;
    JButton search;
    JButton subscribe;
    JButton message;
    JButton invite;
    JButton bye;
    JButton add;
    JButton remove;
    DefaultListModel model;
    JTextArea console;
    MediaReceiver receiver;
    Entity callee = null;
    JFrame prev;

    public void init() {
        this.frame = new JFrame("Sample");
        this.keyword = new JTextField(30);
        this.msgField = new JTextField(30);
        JPanel p1 = new JPanel();
        p1.setLayout(new GridLayout(2, 0));
        JLabel l1 = new JLabel("keyword :");
        JPanel keywordPanel = new JPanel();
        keywordPanel.add(l1);
        keywordPanel.add(this.keyword);
        JLabel msgLable = new JLabel("message :");
        JPanel msgPanel = new JPanel();
        msgPanel.add(msgLable);
        msgPanel.add(this.msgField);
        p1.add(keywordPanel);
        p1.add(msgPanel);
        this.frame.add((Component)p1, "North");
        this.model = new DefaultListModel();
        this.list = new JList(this.model);
        JPanel p2 = new JPanel();
        p2.setLayout(new BorderLayout());
        p2.add((Component)new JScrollPane(this.list), "Center");
        JButton[] buttons = new JButton[7];
        this.add = buttons[0] = new JButton("add");
        this.remove = buttons[1] = new JButton("remove");
        this.search = buttons[2] = new JButton("search");
        this.subscribe = buttons[3] = new JButton("subscribe");
        this.message = buttons[4] = new JButton("message");
        this.invite = buttons[5] = new JButton("invite");
        this.bye = buttons[6] = new JButton("bye");
        JPanel p3 = new JPanel();
        JPanel p4 = new JPanel();
        JPanel p5 = new JPanel();
        p3.setLayout(new GridLayout(2, 0));
        p3.setBorder(new EtchedBorder(0));
        int i = 0;
        JButton[] jButtonArray = buttons;
        int n = 0;
        int n2 = jButtonArray.length;
        while (n < n2) {
            JButton button = jButtonArray[n];
            if (i++ < 3) {
                p4.add(button);
            } else {
                p5.add(button);
            }
            button.addActionListener(this);
            ++n;
        }
        p3.add(p4);
        p3.add(p5);
        p2.add((Component)p3, "South");
        buttons = null;
        this.frame.add((Component)p2, "Center");
        this.console = new JTextArea(6, 30);
        this.frame.add((Component)new JScrollPane(this.console), "South");
        this.frame.setVisible(true);
        this.frame.pack();
        this.frame.setDefaultCloseOperation(3);
        this.receiver = new MediaReceiver();
        this.receiver.addMediaListener(this);
    }

    public void receiveMessage(EntityEvent e) {
        String msg = e.getMessage();
        String temp = this.console.getText();
        temp = String.valueOf(temp) + msg + "\r\n";
        this.console.setText(temp);
    }

    public void receiveAnswer(EntityEvent evt) {
        SessionDescription sdp = evt.getSessionDescription();
        try {
            System.out.println(sdp.toString());
            this.receiver.receiveMedia(sdp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void receiveNotify(EntityEvent evt) {
        SensorData[] sensors;
        Entity source = (Entity)evt.getSource();
        StringBuilder sb = new StringBuilder();
        sb.append("Notify : " + source.toString() + "\r\n");
        sb.append("Location :" + source.getLocation() + "\r\n");
        SensorData[] sensorDataArray = sensors = source.getSensors();
        int n = 0;
        int n2 = sensorDataArray.length;
        while (n < n2) {
            SensorData sensor = sensorDataArray[n];
            sb.append("\tSensor value : " + sensor.getData().toString() + " " + sensor.getMeasure() + "\r\n");
            ++n;
        }
        this.console.setText(sb.toString());
    }

    public void receiveErrorResponse(EntityEvent evt) {
        String msg = evt.getMessage();
        String temp = this.console.getText();
        temp = String.valueOf(temp) + msg + "\r\n";
        this.console.setText(temp);
    }

    public void actionPerformed(ActionEvent evt) {
        EntityContainer con;
        JButton source = (JButton)evt.getSource();
        String msg = this.keyword.getText();
        if (source == this.add) {
            Chord chord = Chord.getInstance();
            if (chord != null) {
                this.addKeyword(msg);
                try {
                    chord.insertEntity(msg, this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (source == this.remove) {
            Chord chord = Chord.getInstance();
            if (chord != null) {
                this.removeKeyword(msg);
                try {
                    chord.removeEntity(msg, this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (source == this.subscribe) {
            Entity target = this.getTarget();
            if (target != null) {
                this.subscribe(target);
            }
        } else if (source == this.message) {
            msg = this.msgField.getText();
            Entity target = this.getTarget();
            if (target != null) {
                this.sendMessage(msg, target);
            } else {
                this.sendMessage(msg);
            }
        } else if (source == this.invite) {
            Entity target = this.getTarget();
            if (target != null) {
                try {
                    this.sendOffer(this.receiver.getRequestSessionDescription(), target);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.callee = target;
            }
        } else if (source == this.bye) {
            if (this.callee != null) {
                this.sendBye(this.callee);
                this.callee = null;
            }
        } else if (source == this.search && (con = this.getContainer()) != null) {
            Entity[] entities = con.searchEntities(msg);
            int i = 0;
            this.model.clear();
            Entity[] entityArray = entities;
            int n = 0;
            int n2 = entityArray.length;
            while (n < n2) {
                Entity entity = entityArray[n];
                this.model.add(i++, entity);
                ++n;
            }
        }
    }

    private Entity getTarget() {
        int index = this.list.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        Entity target = (Entity)this.model.get(index);
        return target;
    }

    public static void main(String[] args) {
        new SampleEntity().init();
    }

    public void receiveMedia(MediaReceiveEvent e) {
        System.out.println("start");
        this.prev = new JFrame("movie");
        JPanel panel = new JPanel();
        Component comp = this.receiver.getVisualComponent();
        panel.setPreferredSize(comp.getPreferredSize());
        panel.add(comp);
        this.prev.add(panel);
        this.prev.pack();
        this.prev.setVisible(true);
    }

    public void terminateMedia(MediaReceiveEvent e) {
        System.out.println("end");
        this.prev.remove(0);
        this.prev.setVisible(false);
    }
}

