/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.RequestLine;
import gov.nist.javax.sip.header.RetryAfter;
import gov.nist.javax.sip.header.StatusLine;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.parser.ParseExceptionListener;
import gov.nist.javax.sip.parser.StringMsgParser;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import gov.nist.javax.sip.stack.UDPMessageProcessor;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.text.ParseException;
import java.util.LinkedList;
import javax.sip.address.Hop;

public class UDPMessageChannel
extends MessageChannel
implements ParseExceptionListener,
Runnable {
    protected SIPTransactionStack sipStack;
    protected StringMsgParser myParser;
    private InetAddress peerAddress;
    private String myAddress;
    private int peerPacketSourcePort;
    private InetAddress peerPacketSourceAddress;
    private int peerPort;
    private String peerProtocol;
    protected int myPort;
    private DatagramPacket incomingPacket;
    private long receptionTime;

    protected UDPMessageChannel(SIPTransactionStack stack, UDPMessageProcessor messageProcessor) {
        this.messageProcessor = messageProcessor;
        this.sipStack = stack;
        Thread mythread = new Thread(this);
        this.myAddress = messageProcessor.getIPAddress().getHostAddress();
        this.myPort = messageProcessor.getPort();
        mythread.setName("UDPMessageChannelThread");
        mythread.setDaemon(true);
        mythread.start();
    }

    protected UDPMessageChannel(SIPTransactionStack stack, UDPMessageProcessor messageProcessor, DatagramPacket packet) {
        this.incomingPacket = packet;
        this.messageProcessor = messageProcessor;
        this.sipStack = stack;
        this.myAddress = messageProcessor.getIPAddress().getHostAddress();
        this.myPort = messageProcessor.getPort();
        Thread mythread = new Thread(this);
        mythread.setDaemon(true);
        mythread.start();
    }

    protected UDPMessageChannel(InetAddress targetAddr, int port, SIPTransactionStack sipStack, UDPMessageProcessor messageProcessor) {
        this.peerAddress = targetAddr;
        this.peerPort = port;
        this.peerProtocol = "UDP";
        this.messageProcessor = messageProcessor;
        this.myAddress = messageProcessor.getIPAddress().getHostAddress();
        this.myPort = messageProcessor.getPort();
        this.sipStack = sipStack;
        if (sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("Creating message channel " + targetAddr.getHostAddress() + "/" + port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            block48: {
                block49: {
                    Object var16_21;
                    SIPMessage sipMessage;
                    block47: {
                        SIPServerTransaction sipServerTx;
                        Object var13_19;
                        ServerRequestInterface sipServerRequest;
                        DatagramPacket packet;
                        if (this.myParser == null) {
                            this.myParser = new StringMsgParser();
                            this.myParser.setParseExceptionListener(this);
                        }
                        if (this.sipStack.threadPoolSize != -1) {
                            LinkedList linkedList = ((UDPMessageProcessor)this.messageProcessor).messageQueue;
                            synchronized (linkedList) {
                                while (((UDPMessageProcessor)this.messageProcessor).messageQueue.isEmpty()) {
                                    if (!((UDPMessageProcessor)this.messageProcessor).isRunning) {
                                        return;
                                    }
                                    try {
                                        ((UDPMessageProcessor)this.messageProcessor).messageQueue.wait();
                                    }
                                    catch (InterruptedException ex) {
                                        if (((UDPMessageProcessor)this.messageProcessor).isRunning) continue;
                                        return;
                                    }
                                }
                                packet = (DatagramPacket)((UDPMessageProcessor)this.messageProcessor).messageQueue.removeFirst();
                            }
                            this.incomingPacket = packet;
                        } else {
                            packet = this.incomingPacket;
                        }
                        this.peerAddress = packet.getAddress();
                        int packetLength = packet.getLength();
                        byte[] bytes = packet.getData();
                        byte[] msgBytes = new byte[packetLength];
                        System.arraycopy(bytes, 0, msgBytes, 0, packetLength);
                        if (this.sipStack.isLoggingEnabled()) {
                            this.sipStack.logWriter.logDebug("UDPMessageChannel: peerAddress = " + this.peerAddress.getHostAddress() + "/" + packet.getPort());
                            this.sipStack.logWriter.logDebug("Length = " + packetLength);
                            String msgString = new String(msgBytes, 0, packetLength);
                            this.sipStack.logWriter.logDebug(msgString);
                        }
                        sipMessage = null;
                        try {
                            this.receptionTime = System.currentTimeMillis();
                            sipMessage = this.myParser.parseSIPMessage(msgBytes);
                            this.myParser = null;
                        }
                        catch (ParseException ex) {
                            this.myParser = null;
                            if (this.sipStack.isLoggingEnabled()) {
                                this.sipStack.logWriter.logDebug("Rejecting message !  " + new String(msgBytes));
                                this.sipStack.logWriter.logDebug("error message " + ex.getMessage());
                                this.sipStack.logWriter.logException(ex);
                            }
                            if (this.sipStack.isLoggingEnabled()) {
                                this.sipStack.getLogWriter().logDebug(new String(msgBytes));
                            }
                            if (this.sipStack.threadPoolSize != -1) continue;
                            return;
                        }
                        if (sipMessage == null) {
                            if (this.sipStack.isLoggingEnabled()) {
                                this.sipStack.logWriter.logDebug("Rejecting message !  " + new String(msgBytes));
                                this.sipStack.logWriter.logDebug("Null message parsed.");
                            }
                            if (this.sipStack.threadPoolSize != -1) continue;
                            return;
                        }
                        ViaList viaList = sipMessage.getViaHeaders();
                        if (sipMessage.getFrom() == null || sipMessage.getTo() == null || sipMessage.getCallId() == null || sipMessage.getCSeq() == null || sipMessage.getViaHeaders() == null) {
                            String badmsg = new String(msgBytes);
                            if (this.sipStack.isLoggingEnabled()) {
                                this.sipStack.logWriter.logError("bad message " + badmsg);
                                this.sipStack.logWriter.logError(">>> Dropped Bad Msg From = " + sipMessage.getFrom() + "To = " + sipMessage.getTo() + "CallId = " + sipMessage.getCallId() + "CSeq = " + sipMessage.getCSeq() + "Via = " + sipMessage.getViaHeaders());
                            }
                            this.sipStack.logWriter.logError("BAD MESSAGE!");
                            this.sipStack.logWriter.logError(badmsg);
                            if (this.sipStack.threadPoolSize != -1) continue;
                            return;
                        }
                        if (sipMessage instanceof SIPRequest) {
                            Via v = (Via)viaList.getFirst();
                            Hop hop = this.sipStack.addressResolver.resolveAddress(v.getHop());
                            this.peerPort = hop.getPort();
                            this.peerProtocol = v.getTransport();
                            this.peerPacketSourceAddress = packet.getAddress();
                            this.peerPacketSourcePort = packet.getPort();
                            try {
                                this.peerAddress = packet.getAddress();
                                boolean hasRPort = v.hasParameter("rport");
                                if (hasRPort || !hop.getHost().equals(this.peerAddress.getHostAddress())) {
                                    v.setParameter("received", this.peerAddress.getHostAddress());
                                }
                                if (hasRPort) {
                                    v.setParameter("rport", Integer.toString(this.peerPacketSourcePort));
                                }
                            }
                            catch (ParseException ex1) {
                                InternalErrorHandler.handleException(ex1);
                            }
                        } else {
                            this.peerPacketSourceAddress = packet.getAddress();
                            this.peerPacketSourcePort = packet.getPort();
                            this.peerAddress = packet.getAddress();
                            this.peerPort = packet.getPort();
                            this.peerProtocol = ((Via)viaList.getFirst()).getTransport();
                        }
                        if (!(sipMessage instanceof SIPRequest)) break block47;
                        SIPRequest sipRequest = (SIPRequest)sipMessage;
                        if (this.sipStack.serverLog.needsLogging(16)) {
                            this.sipStack.serverLog.logMessage(sipMessage, this.getPeerHostPort().toString(), this.getHost() + ":" + this.myPort, false, new Long(this.receptionTime).toString());
                        }
                        if ((sipServerRequest = this.sipStack.newSIPServerRequest(sipRequest, this)) == null) {
                            if (this.sipStack.isLoggingEnabled()) {
                                this.sipStack.logWriter.logWarning("Null request interface returned -- dropping request");
                            }
                            if (sipRequest.getMethod().equals("ACK")) continue;
                            SIPResponse response = sipRequest.createResponse(503);
                            response.addHeader(this.sipStack.createServerHeaderForStack());
                            RetryAfter retryAfter = new RetryAfter();
                            try {
                                retryAfter.setRetryAfter((int)(10.0 * Math.random()));
                                response.setHeader(retryAfter);
                                this.sendMessage(response);
                            }
                            catch (Exception e) {
                                this.sipStack.logWriter.logError("Exception while sending service_unavailable", e);
                            }
                            continue;
                        }
                        if (this.sipStack.isLoggingEnabled()) {
                            this.sipStack.logWriter.logDebug("About to process " + sipRequest.getFirstLine() + "/" + sipServerRequest);
                        }
                        try {
                            sipServerRequest.processRequest(sipRequest, this);
                            var13_19 = null;
                        }
                        catch (Throwable throwable) {
                            var13_19 = null;
                            if (sipServerRequest instanceof SIPTransaction && !(sipServerTx = (SIPServerTransaction)sipServerRequest).passToListener()) {
                                ((SIPTransaction)((Object)sipServerRequest)).releaseSem();
                            }
                            throw throwable;
                        }
                        if (sipServerRequest instanceof SIPTransaction && !(sipServerTx = (SIPServerTransaction)sipServerRequest).passToListener()) {
                            ((SIPTransaction)((Object)sipServerRequest)).releaseSem();
                        }
                        if (this.sipStack.isLoggingEnabled()) {
                            this.sipStack.logWriter.logDebug("Done processing " + sipRequest.getFirstLine() + "/" + sipServerRequest);
                        }
                        break block48;
                    }
                    SIPResponse sipResponse = (SIPResponse)sipMessage;
                    if (sipResponse.getStatusCode() == 100) {
                        sipResponse.getTo().removeParameter("tag");
                    }
                    try {
                        sipResponse.checkHeaders();
                    }
                    catch (ParseException ex) {
                        if (this.sipStack.isLoggingEnabled()) {
                            this.sipStack.logWriter.logError("Dropping Badly formatted response message >>> " + sipResponse);
                        }
                        return;
                    }
                    ServerResponseInterface sipServerResponse = this.sipStack.newSIPServerResponse(sipResponse, this);
                    if (sipServerResponse == null) break block49;
                    try {
                        sipServerResponse.processResponse(sipResponse, this);
                        var16_21 = null;
                    }
                    catch (Throwable throwable) {
                        var16_21 = null;
                        if (sipServerResponse instanceof SIPTransaction && !((SIPTransaction)((Object)sipServerResponse)).passToListener()) {
                            ((SIPTransaction)((Object)sipServerResponse)).releaseSem();
                        }
                        throw throwable;
                    }
                    if (sipServerResponse instanceof SIPTransaction && !((SIPTransaction)((Object)sipServerResponse)).passToListener()) {
                        ((SIPTransaction)((Object)sipServerResponse)).releaseSem();
                    }
                    break block48;
                }
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.logWriter.logDebug("null sipServerResponse!");
                }
            }
            if (this.sipStack.threadPoolSize == -1) break;
        }
    }

    public void handleException(ParseException ex, SIPMessage sipMessage, Class hdrClass, String header, String message) throws ParseException {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logException(ex);
        }
        if (hdrClass != null && (hdrClass.equals(From.class) || hdrClass.equals(To.class) || hdrClass.equals(CSeq.class) || hdrClass.equals(Via.class) || hdrClass.equals(CallID.class) || hdrClass.equals(RequestLine.class) || hdrClass.equals(StatusLine.class))) {
            this.sipStack.logWriter.logError("BAD MESSAGE!");
            this.sipStack.logWriter.logError(message);
            throw ex;
        }
        sipMessage.addUnparsed(header);
    }

    public void sendMessage(SIPMessage sipMessage) throws IOException {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logStackTrace();
        }
        byte[] msg = sipMessage.encodeAsBytes();
        long time = System.currentTimeMillis();
        this.sendMessage(msg, this.peerAddress, this.peerPort, this.peerProtocol, sipMessage instanceof SIPRequest);
        if (this.sipStack.serverLog.needsLogging(16)) {
            this.logMessage(sipMessage, this.peerAddress, this.peerPort, time);
        }
    }

    protected void sendMessage(byte[] msg, InetAddress peerAddress, int peerPort, boolean reConnect) throws IOException {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logStackTrace();
        }
        if (peerPort == -1) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug(this.getClass().getName() + ":sendMessage: Dropping reply!");
            }
            throw new IOException("Receiver port not set ");
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug(this.getClass().getName() + ":sendMessage " + peerAddress.getHostAddress() + "/" + peerPort + "\n" + new String(msg));
            this.sipStack.logWriter.logDebug("*******************\n");
        }
        DatagramPacket reply = new DatagramPacket(msg, msg.length, peerAddress, peerPort);
        try {
            DatagramSocket sock = this.sipStack.udpFlag ? ((UDPMessageProcessor)this.messageProcessor).sock : new DatagramSocket();
            sock.send(reply);
            if (!this.sipStack.udpFlag) {
                sock.close();
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException(ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void sendMessage(byte[] msg, InetAddress peerAddress, int peerPort, String peerProtocol, boolean retry) throws IOException {
        if (peerPort == -1) {
            if (!this.sipStack.isLoggingEnabled()) throw new IOException("Receiver port not set ");
            this.sipStack.logWriter.logDebug(this.getClass().getName() + ":sendMessage: Dropping reply!");
            throw new IOException("Receiver port not set ");
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug(this.getClass().getName() + ":sendMessage " + peerAddress.getHostAddress() + "/" + peerPort + "\n" + new String(msg));
            this.sipStack.logWriter.logDebug("*******************\n");
        }
        if (peerProtocol.compareToIgnoreCase("UDP") == 0) {
            DatagramPacket reply = new DatagramPacket(msg, msg.length, peerAddress, peerPort);
            try {
                DatagramSocket sock = this.sipStack.udpFlag ? ((UDPMessageProcessor)this.messageProcessor).sock : this.sipStack.getNetworkLayer().createDatagramSocket();
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.logWriter.logDebug("sendMessage " + peerAddress.getHostAddress() + "/" + peerPort + "\n" + new String(msg));
                }
                sock.send(reply);
                if (this.sipStack.udpFlag) return;
                sock.close();
                return;
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                InternalErrorHandler.handleException(ex);
                return;
            }
        } else {
            Socket outputSocket = this.sipStack.ioHandler.sendBytes(this.messageProcessor.getIPAddress(), peerAddress, peerPort, "tcp", msg, retry);
            OutputStream myOutputStream = outputSocket.getOutputStream();
            myOutputStream.write(msg, 0, msg.length);
            myOutputStream.flush();
        }
    }

    public SIPTransactionStack getSIPStack() {
        return this.sipStack;
    }

    public String getTransport() {
        return "udp";
    }

    public String getHost() {
        return this.messageProcessor.getIPAddress().getHostAddress();
    }

    public int getPort() {
        return ((UDPMessageProcessor)this.messageProcessor).getPort();
    }

    public String getPeerName() {
        return this.peerAddress.getHostName();
    }

    public String getPeerAddress() {
        return this.peerAddress.getHostAddress();
    }

    protected InetAddress getPeerInetAddress() {
        return this.peerAddress;
    }

    public boolean equals(Object other) {
        boolean retval;
        if (other == null) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            retval = false;
        } else {
            UDPMessageChannel that = (UDPMessageChannel)other;
            retval = this.getKey().equals(that.getKey());
        }
        return retval;
    }

    public String getKey() {
        return UDPMessageChannel.getKey(this.peerAddress, this.peerPort, "UDP");
    }

    public int getPeerPacketSourcePort() {
        return this.peerPacketSourcePort;
    }

    public InetAddress getPeerPacketSourceAddress() {
        return this.peerPacketSourceAddress;
    }

    public String getViaHost() {
        return this.myAddress;
    }

    public int getViaPort() {
        return this.myPort;
    }

    public boolean isReliable() {
        return false;
    }

    public boolean isSecure() {
        return false;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public String getPeerProtocol() {
        return this.peerProtocol;
    }

    public void close() {
    }
}

