/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.util.vizframework.geom;

import java.awt.Shape;
import java.awt.geom.Point2D;
import ow.id.ID;
import ow.tool.util.vizframework.geom.AbstractLineGeometryManager;

public class WavingLineGeometryManager
extends AbstractLineGeometryManager {
    public static final double WAVE_INTENSITY = 0.65;

    public Shape getShapeForMessage(ID src, ID dest) {
        double srcDbl = src.toBigInteger().doubleValue();
        double destDbl = dest.toBigInteger().doubleValue();
        return super.getShapeForMessage(src, dest, this.height((srcDbl + destDbl) / 2.0));
    }

    public Shape getShapeForConnection(ID src, ID dest) {
        double srcDbl = src.toBigInteger().doubleValue();
        double destDbl = dest.toBigInteger().doubleValue();
        return super.getShapeForConnection(src, dest, this.height((srcDbl + destDbl) / 2.0));
    }

    public Point2D getNodePoint2D(ID id) {
        return super.getNodePoint2D(id.toBigInteger().doubleValue(), this.height(id.toBigInteger().doubleValue()));
    }

    private double height(double id) {
        double idRatio = id / this.idSpaceSize;
        return idRatio - 0.5 + Math.sin(idRatio * 2.0 * Math.PI) * 0.65;
    }
}

