/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.util.shellframework;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import ow.messaging.util.AccessControlledServerSocket;
import ow.messaging.util.AccessController;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.Interruptible;
import ow.tool.util.shellframework.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ShellServer<T>
implements Runnable {
    public static final String ENCODING = "US-ASCII";
    private final Map<String, Command<T>> commandTable;
    private final List<Command<T>> commandList;
    private T appDepData;
    private ServerSocket servSock = null;
    protected Thread shellServerThread = null;
    private Set<Interruptible> interruptibleSet = new HashSet<Interruptible>();
    protected Set<PrintStream> outputStreamSet = Collections.synchronizedSet(new HashSet());
    private Queue<String> messageQueue = new LinkedList<String>();
    private Thread printServer = null;

    public ShellServer(Class[] commandClasses, T applicationDependentData, int port) {
        this(commandClasses, applicationDependentData, port, null);
    }

    public ShellServer(Class[] commandClasses, T applicationDependentData, int port, AccessController ac) {
        int i;
        this.appDepData = applicationDependentData;
        this.commandTable = new HashMap<String, Command<T>>();
        ArrayList<Command> reverseCommandList = new ArrayList<Command>();
        for (i = commandClasses.length - 1; i >= 0; --i) {
            String[] names;
            Command cmd;
            Class commandClz = commandClasses[i];
            try {
                cmd = (Command)commandClz.newInstance();
            }
            catch (Exception e) {
                continue;
            }
            reverseCommandList.add(cmd);
            for (String name : names = cmd.getNames()) {
                for (int j = 1; j <= name.length(); ++j) {
                    String key = name.substring(0, j);
                    this.commandTable.put(key, cmd);
                }
            }
        }
        this.commandList = new ArrayList<Command<T>>();
        for (i = reverseCommandList.size() - 1; i >= 0; --i) {
            this.commandList.add((Command<T>)reverseCommandList.get(i));
        }
        if (port >= 0 && port < 65536) {
            try {
                this.servSock = new AccessControlledServerSocket(ac);
                this.servSock.setReuseAddress(true);
                this.servSock.bind(new InetSocketAddress(port));
            }
            catch (IOException e) {
                System.err.println("An Exception thrown:");
                e.printStackTrace();
                return;
            }
            Thread t = new Thread(this);
            t.setName("ShellServer");
            t.setDaemon(true);
            t.start();
            System.out.println("A shell server is waiting on the port tcp/" + port);
        }
    }

    @Override
    public void run() {
        this.shellServerThread = Thread.currentThread();
        while (true) {
            Socket sock;
            try {
                sock = this.servSock.accept();
            }
            catch (IOException e) {
                System.out.println("Halt.");
                break;
            }
            Shell<T> sh = null;
            try {
                sh = new Shell<T>(sock, this, this.commandTable, this.commandList, this.appDepData);
            }
            catch (Exception e) {
                continue;
            }
            Thread t = new Thread(sh);
            t.setName("A Shell");
            t.setDaemon(false);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInterruptible(Interruptible t) {
        Set<Interruptible> set = this.interruptibleSet;
        synchronized (set) {
            this.interruptibleSet.add(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInterruptible(Interruptible t) {
        Set<Interruptible> set = this.interruptibleSet;
        synchronized (set) {
            this.interruptibleSet.remove(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptAllInterruptible() {
        Set<Interruptible> set = this.interruptibleSet;
        synchronized (set) {
            for (Interruptible t : this.interruptibleSet) {
                t.interrupt();
            }
        }
    }

    public Thread getShellServerThread() {
        return this.shellServerThread;
    }

    public Map<String, Command<T>> getCommandTable() {
        return this.commandTable;
    }

    protected List<Command<T>> getCommandList() {
        return this.commandList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(String str) {
        this.startPrintServer();
        Queue<String> queue = this.messageQueue;
        synchronized (queue) {
            this.messageQueue.offer(str);
            this.messageQueue.notify();
        }
    }

    public void println(String str) {
        this.print(str + "\n");
    }

    private synchronized void startPrintServer() {
        if (this.printServer == null) {
            PrintServer r = new PrintServer();
            Thread t = new Thread(r);
            t.setName("PrintServer");
            t.setDaemon(true);
            t.start();
            this.printServer = t;
        }
    }

    private class PrintServer
    implements Runnable {
        private PrintServer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                String message = null;
                Collection<Object> collection = ShellServer.this.messageQueue;
                synchronized (collection) {
                    try {
                        message = (String)ShellServer.this.messageQueue.remove();
                    }
                    catch (NoSuchElementException e) {
                        message = null;
                    }
                    if (message == null) {
                        try {
                            ShellServer.this.messageQueue.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                collection = ShellServer.this.outputStreamSet;
                synchronized (collection) {
                    for (PrintStream out : ShellServer.this.outputStreamSet) {
                        out.print(message);
                        out.flush();
                    }
                }
            }
        }
    }
}

