/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.scenariogen.commands;

import java.io.PrintStream;
import java.io.PrintWriter;
import ow.tool.scenariogen.ScenarioGeneratorContext;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinCommand
implements Command<ScenarioGeneratorContext> {
    private static final String[] NAMES = new String[]{"join"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "join <start time> <interval>";
    }

    @Override
    public boolean execute(ShellContext<ScenarioGeneratorContext> context) {
        ScenarioGeneratorContext cxt = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        if (args.length < 2) {
            out.println("Usage: " + this.getHelp());
            return false;
        }
        long startTime = (long)(Double.parseDouble(args[0]) * 1000.0);
        long interval = (long)(Double.parseDouble(args[1]) * 1000.0);
        int numNodes = cxt.getNumberOfNodes();
        cxt.setNumberOfNodes(numNodes);
        cxt.setJoinStatusToAllNodes(true);
        PrintWriter writer = cxt.getWriter();
        long time = startTime;
        for (int i = 1; i < numNodes; ++i) {
            cxt.setJoinStatus(i, true);
            writer.print("schedule ");
            writer.print(time);
            writer.print(" control ");
            writer.print(i + 1);
            writer.print(" init emu1");
            writer.println();
            time += interval;
        }
        writer.flush();
        out.println("finish at " + (double)time / 1000.0);
        return false;
    }
}

