/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.scenariogen.commands;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Random;
import ow.tool.scenariogen.ScenarioGeneratorContext;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChurnCommand
implements Command<ScenarioGeneratorContext> {
    private static final String[] NAMES = new String[]{"churn"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "churn <start time> <end time> <frequency (times/sec)>";
    }

    @Override
    public boolean execute(ShellContext<ScenarioGeneratorContext> context) {
        ScenarioGeneratorContext cxt = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        if (args.length < 3) {
            out.println("Usage: " + this.getHelp());
            return false;
        }
        long startTime = (long)(Double.parseDouble(args[0]) * 1000.0);
        long endTime = (long)(Double.parseDouble(args[1]) * 1000.0);
        double freq = 1000.0 / Double.parseDouble(args[2]);
        if (startTime >= endTime || freq <= 0.0) {
            out.println("Invalid arguments.");
            return false;
        }
        PrintWriter writer = cxt.getWriter();
        int numNodes = cxt.getNumberOfNodes();
        Random rnd = new Random(System.currentTimeMillis());
        double time = startTime;
        while (true) {
            double timeStep = -Math.log(1.0 - rnd.nextDouble());
            if ((time += (timeStep *= freq)) >= (double)endTime) break;
            int n = rnd.nextInt(numNodes - 1) + 2;
            long t = (long)time;
            writer.print("schedule ");
            writer.print(t);
            writer.print(" control ");
            writer.print(n);
            writer.println(" halt");
            writer.print("schedule ");
            writer.print(t + 10L);
            writer.print(" invoke ");
            writer.println(n);
            writer.print("schedule ");
            writer.print(t + 100L);
            writer.print(" control ");
            writer.print(n);
            writer.println(" init emu1");
        }
        writer.flush();
        return false;
    }
}

