/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.msgcounter;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import ow.messaging.MessagingAddress;
import ow.messaging.Tag;
import ow.msgstat.CallbackOnNodeStatus;
import ow.msgstat.StatCollector;
import ow.msgstat.StatCollectorConfiguration;
import ow.msgstat.StatCollectorFactory;
import ow.tool.msgcounter.IntegerCounter;

public class MessageCounter
implements CallbackOnNodeStatus {
    private final StatCollectorConfiguration config;
    private StatCollector statCollector = null;
    private final Map<Integer, IntegerCounter> totalCounterMap = new HashMap<Integer, IntegerCounter>();
    private final Map<Integer, IntegerCounter> lapCounterMap = new HashMap<Integer, IntegerCounter>();
    private final SortedSet<Integer> tagSet = new TreeSet<Integer>();
    private final Set<MessagingAddress> nodeSet = new HashSet<MessagingAddress>();
    private int maxNumNode = 0;

    public MessageCounter() {
        this.config = StatCollectorFactory.getDefaultConfiguration();
    }

    public void start() throws Exception {
        if (this.statCollector == null) {
            this.statCollector = StatCollectorFactory.getStatCollector(this.config);
            this.statCollector.start(this);
        }
    }

    public void stop() {
        if (this.statCollector != null) {
            this.statCollector.stop();
            this.statCollector = null;
        }
    }

    public synchronized void clear() {
        this.lapCounterMap.clear();
        this.totalCounterMap.clear();
        this.tagSet.clear();
    }

    public synchronized void messageSent(MessagingAddress source, MessagingAddress target, int tag) {
        IntegerCounter intCounter = null;
        intCounter = this.lapCounterMap.get(tag);
        if (intCounter == null) {
            intCounter = new IntegerCounter();
            this.lapCounterMap.put(tag, intCounter);
            this.tagSet.add(tag);
        }
        intCounter.increment();
        intCounter = this.totalCounterMap.get(tag);
        if (intCounter == null) {
            intCounter = new IntegerCounter();
            this.totalCounterMap.put(tag, intCounter);
            this.tagSet.add(tag);
        }
        intCounter.increment();
        this.nodeSet.add(source);
        int size = this.nodeSet.size();
        if (size > this.maxNumNode) {
            this.maxNumNode = size;
        }
    }

    public void deleteNode(MessagingAddress node) {
        this.nodeSet.remove(node);
    }

    public synchronized String getCountsString() {
        int count;
        IntegerCounter intCounter;
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("Message count (lap):\n");
        int sum = 0;
        for (Integer i : this.tagSet) {
            intCounter = this.lapCounterMap.get(i);
            if (intCounter == null) continue;
            count = intCounter.getCount();
            sum += count;
            sb.append(Tag.getStringByNumber(i));
            sb.append(", ");
            sb.append(count);
            sb.append("\n");
        }
        sb.append("messages and nodes (lap), ");
        sb.append(sum);
        sb.append(", ");
        sb.append(this.nodeSet.size());
        sb.append("\n\n");
        this.lapCounterMap.clear();
        sb.append("Message count (total):\n");
        sum = 0;
        for (Integer i : this.tagSet) {
            intCounter = this.totalCounterMap.get(i);
            count = intCounter.getCount();
            sum += count;
            sb.append(Tag.getStringByNumber(i));
            sb.append(", ");
            sb.append(count);
            sb.append("\n");
        }
        sb.append("messages and nodes (total), ");
        sb.append(sum);
        sb.append(", ");
        sb.append(this.maxNumNode);
        sb.append("\n\n");
        return sb.toString();
    }
}

