/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.msgcounter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import ow.messaging.util.AccessController;
import ow.tool.emulator.EmulatorControllable;
import ow.tool.msgcounter.MessageCounter;
import ow.tool.msgcounter.commands.HaltCommand;
import ow.tool.msgcounter.commands.HelpCommand;
import ow.tool.msgcounter.commands.QuitCommand;
import ow.tool.msgcounter.commands.StatusCommand;
import ow.tool.util.shellframework.Shell;
import ow.tool.util.shellframework.ShellServer;

public final class Main
implements EmulatorControllable {
    private static final String COMMAND = "owmsgcounter";
    private final int DEFAULT_SHELL_PORT = -1;
    private static final Class[] COMMANDS = new Class[]{StatusCommand.class, HelpCommand.class, QuitCommand.class, HaltCommand.class};

    protected void usage(String command) {
        System.out.print("Usage: " + command + " [-p <shell port>] [--acl <ACL file>]");
    }

    public static void main(String[] args) {
        new Main().start(args);
    }

    protected void start(String[] args) {
        try {
            this.start(0, args, new BufferedReader(new InputStreamReader(System.in, "US-ASCII")), System.out, true);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void start(int id, String[] args, BufferedReader in, PrintStream out) {
        this.start(id, args, in, out, false);
    }

    private void start(int id, String[] args, BufferedReader in, PrintStream out, boolean interactive) {
        String optVal;
        int shellPort = -1;
        AccessController ac = null;
        Options opts = new Options();
        opts.addOption("h", "help", true, "print help");
        opts.addOption("p", "port", true, "port number");
        opts.addOption("A", "acl", true, "access control list file");
        PosixParser parser = new PosixParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(opts, args);
        }
        catch (ParseException e) {
            System.out.println("There is an invalid option.");
            e.printStackTrace();
            System.exit(1);
        }
        if (cmd.hasOption('h')) {
            this.usage(COMMAND);
            System.exit(1);
        }
        if ((optVal = cmd.getOptionValue('p')) != null) {
            shellPort = Integer.parseInt(optVal);
        }
        if ((optVal = cmd.getOptionValue("A")) != null) {
            try {
                ac = new AccessController(optVal);
            }
            catch (IOException e) {
                System.err.println("An Exception thrown:");
                e.printStackTrace();
                return;
            }
        }
        args = cmd.getArgs();
        MessageCounter msgCounter = new MessageCounter();
        try {
            msgCounter.start();
        }
        catch (Exception e) {
            System.err.println("An Exception thrown:");
            e.printStackTrace();
            return;
        }
        if (shellPort >= 0 && shellPort < 65536) {
            ShellServer<MessageCounter> shellServ = new ShellServer<MessageCounter>(COMMANDS, msgCounter, shellPort, ac);
        }
        Shell<MessageCounter> stdioShell = new Shell<MessageCounter>(in, out, COMMANDS, msgCounter, interactive);
        stdioShell.run();
    }
}

