/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.mcastshell.commands;

import java.io.PrintStream;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.mcast.Mcast;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeighborsCommand
implements Command<Mcast> {
    private static final String[] NAMES = new String[]{"neighbors"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "neighbors";
    }

    @Override
    public boolean execute(ShellContext<Mcast> context) {
        Mcast mcast = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        StringBuilder sb = new StringBuilder();
        ID[] groups = mcast.getGroupsWithSpanningTree();
        if (groups != null) {
            for (ID groupID : groups) {
                IDAddressPair parent = mcast.getParent(groupID);
                IDAddressPair[] children = mcast.getChildren(groupID);
                sb.append("group ID: ");
                sb.append(groupID);
                sb.append("\r\n parent:");
                if (parent != null) {
                    sb.append(" ");
                    sb.append(parent.getAddress());
                }
                sb.append("\r\n children:");
                if (children != null) {
                    for (IDAddressPair child : children) {
                        sb.append("\r\n  ");
                        sb.append(child.getAddress());
                    }
                }
                sb.append("\r\n");
            }
        }
        out.print(sb.toString());
        out.flush();
        return false;
    }
}

