/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.emulator.commands;

import java.io.PrintStream;
import java.util.TimerTask;
import ow.tool.emulator.EmulatorContext;
import ow.tool.emulator.EmulatorMode;
import ow.tool.emulator.SchedulableCommand;
import ow.tool.emulator.action.InvocationTask;
import ow.tool.util.shellframework.ShellContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvokeCommand
implements SchedulableCommand<EmulatorContext> {
    private static final String[] NAMES = new String[]{"invoke"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "invoke [<ID of app instace>]";
    }

    @Override
    public boolean execute(ShellContext<EmulatorContext> context) {
        EmulatorContext cxt = context.getOpaqueData();
        String[] args = context.getArguments();
        PrintStream out = context.getOutputStream();
        TimerTask task = this.getTimerTask(context);
        if (task == null) {
            out.println("Usage: " + this.getHelp());
            return !context.isInteractive();
        }
        if (cxt.getEmulatorMode() != EmulatorMode.WORKER) {
            out.println("invoke: " + args[0] + ".");
            out.println();
        }
        task.run();
        return false;
    }

    @Override
    public TimerTask getTimerTask(ShellContext<EmulatorContext> context) {
        EmulatorContext cxt = context.getOpaqueData();
        String[] args = context.getArguments();
        int hostID = -1;
        if (args.length >= 1) {
            hostID = Integer.parseInt(args[0]);
        }
        return new InvocationTask(cxt, hostID, cxt.getCurrentClass(), cxt.getCurrentMainMethod(), cxt.getCurrentArguments(), cxt.getCurrentRelativePriority());
    }
}

