/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.emulator.action;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.TimerTask;
import ow.tool.emulator.EmulatorContext;
import ow.tool.emulator.EmulatorMode;
import ow.tool.emulator.Task;

public class ControlTask
extends TimerTask
implements Task {
    private EmulatorContext cxt;
    private int id;
    private PrintStream out;
    private String command;

    public ControlTask(EmulatorContext cxt, int id, PrintStream out, String command) {
        this.cxt = cxt;
        this.id = id;
        this.out = out;
        this.command = command;
    }

    public Task clone() {
        return new ControlTask(this.cxt, this.id, this.out, this.command);
    }

    public boolean doesExit() {
        return false;
    }

    public void run() {
        if (this.id < 0) {
            this.out.print("control all: " + this.command + "\r\n");
            String prefix = this.cxt.getEmulatorMode() == EmulatorMode.MASTER ? "control all " : "";
            try {
                Collection<BufferedWriter> controlPipes = this.cxt.getAllControlPipes();
                for (BufferedWriter controlPipe : controlPipes) {
                    controlPipe.write(prefix + this.command + "\n");
                    controlPipe.flush();
                }
            }
            catch (IOException e) {
                this.out.print("An IOException thrown while writing a command into a pipe:\r\n");
                e.printStackTrace(this.out);
            }
        } else {
            BufferedWriter controlPipe;
            if (this.cxt.getEmulatorMode() != EmulatorMode.WORKER) {
                this.out.print("control " + this.id + ": " + this.command + "\r\n");
            }
            if ((controlPipe = this.cxt.getControlPipe(this.id)) == null) {
                System.err.println("There is no application instance with id: " + this.id);
                return;
            }
            String prefix = this.cxt.getEmulatorMode() == EmulatorMode.MASTER ? "control " + this.id + " " : "";
            try {
                controlPipe.write(prefix + this.command + "\n");
                controlPipe.flush();
            }
            catch (IOException e) {
                this.out.print("An IOException thrown while writing a command into a pipe:\r\n");
                e.printStackTrace(this.out);
            }
        }
    }
}

