/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.pastry;

import java.util.Comparator;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.id.comparator.AlgoBasedTowardTargetIDAddrComparator;
import ow.id.comparator.ClockwiseFromSrcIDAddrComparator;
import ow.id.comparator.ClockwiseTowardTargetIDAddrComparator;
import ow.routing.RoutingAlgorithm;
import ow.tool.dhtshell.XmlRpcDHTServer;
import ow.util.HTMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LeafSet {
    private final int oneSideSize;
    private SortedSet<IDAddressPair> smallerSet;
    private SortedSet<IDAddressPair> largerSet;
    private volatile RoutingAlgorithm algorithm = null;
    private volatile IDAddressPair selfIDAddress = null;
    private volatile Comparator<IDAddressPair> smallerComparator = null;
    private volatile Comparator<IDAddressPair> largerComparator = null;

    public LeafSet(RoutingAlgorithm algorithm, int idSizeInBit, IDAddressPair self, int oneSideSize) {
        this.algorithm = algorithm;
        this.selfIDAddress = self;
        this.oneSideSize = oneSideSize;
        this.smallerComparator = new ClockwiseTowardTargetIDAddrComparator(idSizeInBit, this.selfIDAddress.getID());
        this.largerComparator = new ClockwiseFromSrcIDAddrComparator(idSizeInBit, this.selfIDAddress.getID());
        this.clear();
    }

    synchronized void clear() {
        this.smallerSet = new TreeSet<IDAddressPair>(this.smallerComparator);
        this.largerSet = new TreeSet<IDAddressPair>(this.largerComparator);
    }

    public void add(IDAddressPair elem) {
        if (elem.equals(this.selfIDAddress)) {
            return;
        }
        this.addToSortedSet(this.smallerSet, elem);
        this.addToSortedSet(this.largerSet, elem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToSortedSet(SortedSet<IDAddressPair> set, IDAddressPair elem) {
        SortedSet<IDAddressPair> sortedSet = set;
        synchronized (sortedSet) {
            set.add(elem);
            while (set.size() > this.oneSideSize) {
                IDAddressPair lastElem = set.last();
                set.remove(lastElem);
            }
        }
    }

    public void merge(IDAddressPair[] leafSet) {
        if (leafSet != null) {
            this.mergeToSortedSet(this.smallerSet, leafSet);
            this.mergeToSortedSet(this.largerSet, leafSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeToSortedSet(SortedSet<IDAddressPair> set, IDAddressPair[] oneSideLeafSet) {
        SortedSet<IDAddressPair> sortedSet = set;
        synchronized (sortedSet) {
            IDAddressPair[] iDAddressPairArray = oneSideLeafSet;
            synchronized (oneSideLeafSet) {
                for (IDAddressPair p : oneSideLeafSet) {
                    if (p == null || p.equals(this.selfIDAddress)) continue;
                    set.add(p);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                while (set.size() > this.oneSideSize) {
                    IDAddressPair lastElem = set.last();
                    set.remove(lastElem);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(IDAddressPair elem) {
        SortedSet<IDAddressPair> sortedSet = this.smallerSet;
        synchronized (sortedSet) {
            this.smallerSet.remove(elem);
        }
        sortedSet = this.largerSet;
        synchronized (sortedSet) {
            this.largerSet.remove(elem);
        }
    }

    public boolean coversWithSmallerSet(IDAddressPair elem) {
        try {
            IDAddressPair smallest = this.smallerSet.last();
            if (this.smallerComparator.compare(elem, smallest) <= 0 && !elem.equals(this.selfIDAddress)) {
                return true;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return false;
    }

    public boolean coversWithLargerSet(IDAddressPair elem) {
        try {
            IDAddressPair largest = this.largerSet.last();
            if (this.largerComparator.compare(elem, largest) <= 0 && !elem.equals(this.selfIDAddress)) {
                return true;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean coversEntireRing() {
        IDAddressPair smallest = null;
        IDAddressPair largest = null;
        try {
            SortedSet<IDAddressPair> sortedSet = this.smallerSet;
            synchronized (sortedSet) {
                smallest = this.smallerSet.last();
            }
            if (this.largerSet.contains(smallest)) {
                return true;
            }
            sortedSet = this.largerSet;
            synchronized (sortedSet) {
                largest = this.largerSet.last();
            }
            if (this.smallerSet.contains(largest)) {
                return true;
            }
        }
        catch (NoSuchElementException e) {
            return true;
        }
        return false;
    }

    public int getOneSideSize() {
        return this.oneSideSize;
    }

    public int getNumberOfSmallerNodes() {
        return this.getSizeOfSortedSet(this.smallerSet);
    }

    public int getNumberOfLargerNodes() {
        return this.getSizeOfSortedSet(this.largerSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSizeOfSortedSet(SortedSet<IDAddressPair> set) {
        SortedSet<IDAddressPair> sortedSet = set;
        synchronized (sortedSet) {
            return set.size();
        }
    }

    public IDAddressPair getSmallestNode() {
        return this.getLastElement(this.smallerSet);
    }

    public IDAddressPair getLargestNode() {
        return this.getLastElement(this.largerSet);
    }

    private IDAddressPair getLastElement(SortedSet<IDAddressPair> set) {
        IDAddressPair ret = null;
        try {
            ret = set.last();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDAddressPair[] closestNodes(ID target, int maxNum) {
        AlgoBasedTowardTargetIDAddrComparator towardTargetComparator = new AlgoBasedTowardTargetIDAddrComparator(this.algorithm, target);
        TreeSet<IDAddressPair> result = new TreeSet<IDAddressPair>(towardTargetComparator);
        result.add(this.selfIDAddress);
        SortedSet<IDAddressPair> sortedSet = this.smallerSet;
        synchronized (sortedSet) {
            result.addAll(this.smallerSet);
        }
        sortedSet = this.largerSet;
        synchronized (sortedSet) {
            result.addAll(this.largerSet);
        }
        while (result.size() > maxNum) {
            IDAddressPair lastElem = (IDAddressPair)result.last();
            result.remove(lastElem);
        }
        IDAddressPair[] ret = new IDAddressPair[result.size()];
        result.toArray(ret);
        return ret;
    }

    public IDAddressPair[] getArrayOfSmallerSet(IDAddressPair toBeExcepted) {
        return LeafSet.getArrayOfSet(this.smallerSet, toBeExcepted);
    }

    public IDAddressPair[] getArrayOfLargerSet(IDAddressPair toBeExcepted) {
        return LeafSet.getArrayOfSet(this.largerSet, toBeExcepted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IDAddressPair[] getArrayOfSet(Set<IDAddressPair> set, IDAddressPair exclude) {
        IDAddressPair[] ret;
        HashSet<IDAddressPair> retSet = new HashSet<IDAddressPair>();
        Set<IDAddressPair> set2 = set;
        synchronized (set2) {
            for (IDAddressPair p : set) {
                if (p.equals(exclude)) continue;
                retSet.add(p);
            }
            ret = new IDAddressPair[retSet.size()];
            retSet.toArray(ret);
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        IDAddressPair[] array = new IDAddressPair[this.smallerSet.size()];
        this.smallerSet.toArray(array);
        for (int i = array.length - 1; i >= 0; --i) {
            sb.append(" ");
            sb.append(array[i].getAddress());
        }
        sb.append(" |");
        for (IDAddressPair p : this.largerSet) {
            sb.append(" ");
            sb.append(p.getAddress());
        }
        sb.append("]");
        return sb.toString();
    }

    public String toHTMLString() {
        String url;
        StringBuilder sb = new StringBuilder();
        IDAddressPair[] smallerSetArray = new IDAddressPair[this.smallerSet.size()];
        this.smallerSet.toArray(smallerSetArray);
        for (int i = smallerSetArray.length - 1; i >= 0; --i) {
            url = XmlRpcDHTServer.convertMessagingAddressToURL(smallerSetArray[i].getAddress());
            sb.append("<a href=\"" + url + "\">" + HTMLUtil.stringInHTML(url) + "</a><br>\n");
        }
        url = XmlRpcDHTServer.convertMessagingAddressToURL(this.selfIDAddress.getAddress());
        sb.append("<a href=\"" + url + "\">" + HTMLUtil.stringInHTML(url) + "</a> (self)<br>\n");
        for (IDAddressPair p : this.largerSet) {
            url = XmlRpcDHTServer.convertMessagingAddressToURL(p.getAddress());
            sb.append("<a href=\"" + url + "\">" + HTMLUtil.stringInHTML(url) + "</a><br>\n");
        }
        return sb.toString();
    }
}

