/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.impl;

import java.io.Serializable;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.messaging.Message;
import ow.messaging.Tag;
import ow.routing.CallbackResultFilter;
import ow.routing.RoutingContext;
import ow.routing.RoutingResult;

public class RoutingDriverMessageFactory {
    public static Message getPingMessage(IDAddressPair src) {
        int tag = Tag.PING.getNumber();
        return new Message(src, tag, new Serializable[0]);
    }

    public static Message getAckMessage(IDAddressPair src) {
        int tag = Tag.ACK.getNumber();
        return new Message(src, tag, new Serializable[0]);
    }

    public static Message getIteRouteNoneMessage(IDAddressPair src, ID target, int numClosestNodes, int numNeighbors, RoutingContext cxt) {
        int tag = Tag.ITE_ROUTE_NONE.getNumber();
        return new Message(src, tag, target, Integer.valueOf(numClosestNodes), Integer.valueOf(numNeighbors), cxt);
    }

    public static Message getIteRouteInvokeMessage(IDAddressPair src, ID target, int numClosestNodes, int numNeighbors, RoutingContext cxt, CallbackResultFilter filter, int callbackTag, Serializable[] callbackArgs, IDAddressPair lastHop) {
        int tag = Tag.ITE_ROUTE_INVOKE.getNumber();
        return new Message(src, tag, target, Integer.valueOf(numClosestNodes), Integer.valueOf(numNeighbors), cxt, filter, Integer.valueOf(callbackTag), callbackArgs, lastHop);
    }

    public static Message getIteRouteJoinMessage(IDAddressPair src, IDAddressPair joiningNode, int numClosestNodes, int numNeighbors, RoutingContext cxt, IDAddressPair lastHop) {
        int tag = Tag.ITE_ROUTE_JOIN.getNumber();
        return new Message(src, tag, joiningNode, Integer.valueOf(numClosestNodes), Integer.valueOf(numNeighbors), cxt, lastHop);
    }

    public static Message getIteAdjustLastHopReq(IDAddressPair src, ID target) {
        int tag = Tag.ITE_ADJUST_LAST_HOP_REQ.getNumber();
        return new Message(src, tag, target);
    }

    public static Message getIteAdjustLastHopRep(IDAddressPair src, IDAddressPair[] adjustedLastHops) {
        int tag = Tag.ITE_ADJUST_LAST_HOP_REP.getNumber();
        return new Message(src, tag, new Serializable[]{adjustedLastHops});
    }

    public static Message getIteNoneMessage(IDAddressPair src, int numNeighborsRequested) {
        int tag = Tag.ITE_NONE.getNumber();
        return new Message(src, tag, Integer.valueOf(numNeighborsRequested));
    }

    public static Message getIteInvokeMessage(IDAddressPair src, ID target, int numNeighborsRequested, CallbackResultFilter filter, int callbackTag, Serializable[] callbackArgs, IDAddressPair lastHop) {
        int tag = Tag.ITE_INVOKE.getNumber();
        return new Message(src, tag, target, Integer.valueOf(numNeighborsRequested), filter, Integer.valueOf(callbackTag), callbackArgs, lastHop);
    }

    public static Message getIteJoinMessage(IDAddressPair src, IDAddressPair joiningNode, int numNeighborsRequested, IDAddressPair lastHop) {
        int tag = Tag.ITE_JOIN.getNumber();
        return new Message(src, tag, joiningNode, Integer.valueOf(numNeighborsRequested), lastHop);
    }

    public static Message getIteReplyMessage(IDAddressPair src, IDAddressPair[] closestNodes, IDAddressPair[] neighbors, Serializable callbackResult) {
        int tag = Tag.ITE_REPLY.getNumber();
        return new Message(src, tag, closestNodes, neighbors, callbackResult);
    }

    public static Message getRecRouteNoneMessage(IDAddressPair src, ID target, int numNeighbors, RoutingContext cxt, IDAddressPair initiator, int ttl, boolean adjustLastHop, IDAddressPair[] route) {
        int tag = Tag.REC_ROUTE_NONE.getNumber();
        return new Message(src, tag, null, target, Integer.valueOf(numNeighbors), cxt, initiator, Integer.valueOf(ttl), Boolean.valueOf(adjustLastHop), route);
    }

    public static Message getRecRouteInvokeMessage(IDAddressPair src, ID target, int numNeighbors, RoutingContext cxt, IDAddressPair initiator, int ttl, boolean adjustLastHop, CallbackResultFilter filter, int callbackTag, Serializable[] callbackArgs, IDAddressPair[] route) {
        int tag = Tag.REC_ROUTE_INVOKE.getNumber();
        return new Message(src, tag, null, target, Integer.valueOf(numNeighbors), cxt, initiator, Integer.valueOf(ttl), Boolean.valueOf(adjustLastHop), filter, Integer.valueOf(callbackTag), callbackArgs, route);
    }

    public static Message getRecRouteJoinMessage(IDAddressPair src, IDAddressPair joiningNode, int numNeighbors, RoutingContext cxt, int ttl, boolean adjustLastHop, IDAddressPair[] route) {
        int tag = Tag.REC_ROUTE_JOIN.getNumber();
        return new Message(src, tag, null, joiningNode, Integer.valueOf(numNeighbors), cxt, Integer.valueOf(ttl), Boolean.valueOf(adjustLastHop), route);
    }

    public static Message getRecNoneMessage(IDAddressPair src, ID target, int numNeighbors, IDAddressPair initiator, IDAddressPair[] route) {
        int tag = Tag.REC_NONE.getNumber();
        return new Message(src, tag, null, target, Integer.valueOf(numNeighbors), initiator, route);
    }

    public static Message getRecInvokeMessage(IDAddressPair src, ID target, int numNeighbors, IDAddressPair initiator, CallbackResultFilter filter, int callbackTag, Serializable[] callbackArgs, IDAddressPair[] route) {
        int tag = Tag.REC_INVOKE.getNumber();
        return new Message(src, tag, null, target, Integer.valueOf(numNeighbors), initiator, filter, Integer.valueOf(callbackTag), callbackArgs, route);
    }

    public static Message getRecJoinMessage(IDAddressPair src, IDAddressPair joiningNode, int numNeighbors, IDAddressPair[] route) {
        int tag = Tag.REC_JOIN.getNumber();
        return new Message(src, tag, null, joiningNode, Integer.valueOf(numNeighbors), route);
    }

    public static Message getRecAckMessage(IDAddressPair src) {
        int tag = Tag.REC_ACK.getNumber();
        return new Message(src, tag, new Serializable[0]);
    }

    public static Message getRecResultMessage(IDAddressPair src, ID target, RoutingResult routingRes, Serializable callbackResult) {
        int tag = Tag.REC_RESULT.getNumber();
        return new Message(src, tag, null, target, routingRes, callbackResult);
    }

    public static void setBlackList(Message msg, IDAddressPair[] blackList) {
        msg.setContents(0, (Serializable)blackList);
    }
}

