/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.id.IDAddressRoutingContextTriplet;
import ow.messaging.Message;
import ow.messaging.MessageHandler;
import ow.messaging.MessageReceiver;
import ow.messaging.MessagingAddress;
import ow.messaging.MessagingProvider;
import ow.messaging.Tag;
import ow.msgstat.StatReporter;
import ow.routing.CallbackResultFilter;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingContext;
import ow.routing.RoutingResult;
import ow.routing.RoutingServiceConfiguration;
import ow.routing.impl.AbstractContactList;
import ow.routing.impl.AbstractRoutingDriver;
import ow.routing.impl.ContactList;
import ow.routing.impl.InsertedOrderContactList;
import ow.routing.impl.RoutingDriverMessageFactory;
import ow.routing.impl.SortedContactList;

public final class IterativeRoutingDriver
extends AbstractRoutingDriver {
    protected IterativeRoutingDriver(RoutingServiceConfiguration conf, MessagingProvider provider, MessageReceiver receiver, ExecutorService threadPool, RoutingAlgorithmConfiguration algoConf, ID selfID) throws IOException {
        super(conf, provider, receiver, threadPool, algoConf, selfID);
        this.prepareHandlers();
    }

    public RoutingResult routeToRootNode(ID target, int numNeighbors) {
        return this.routeOrJoin(true & this.adjustRoot, Tag.ITE_ROUTE_NONE, target, numNeighbors, null, null, -1, null, null);
    }

    public RoutingResult routeToClosestNode(ID target, int numNeighbors) {
        return this.routeOrJoin(false, Tag.ITE_ROUTE_NONE, target, numNeighbors, null, null, -1, null, null);
    }

    public RoutingResult invokeCallbacksOnRoute(ID target, int numNeighbors, Serializable[] returnedValue, CallbackResultFilter filter, int tag, Serializable[] args) {
        return this.routeOrJoin(true & this.adjustRoot, Tag.ITE_ROUTE_INVOKE, target, numNeighbors, filter, returnedValue, tag, args, null);
    }

    public RoutingResult join(MessagingAddress initialContact) {
        RoutingResult res = this.routeOrJoin(true & this.adjustRoot, Tag.ITE_ROUTE_JOIN, this.getSelfIDAddressPair().getID(), this.config.getNumOfNeighborsRequestedWhenJoining(), null, null, -1, null, initialContact);
        this.algorithm.join(res.getNeighbors());
        return res;
    }

    private RoutingResult routeOrJoin(boolean adjustLastHop, Tag msgType, ID dest, int numNeighbors, CallbackResultFilter filter, Serializable[] resultingCallbackResult, int callbackTag, Serializable[] callbackArgs, MessagingAddress joinInitialContact) {
        IDAddressPair contact;
        IDAddressPair[] neighbors;
        Serializable callbackResult;
        IDAddressPair lastContact;
        AbstractContactList contactList;
        IDAddressPair[] adjustedLastHops;
        Set<MessagingAddress> blackList;
        List<IDAddressPair> route;
        block45: {
            int i;
            int queryConcurrency;
            block44: {
                if (numNeighbors < 1) {
                    numNeighbors = 1;
                }
                route = Collections.synchronizedList(new ArrayList());
                blackList = Collections.synchronizedSet(new HashSet());
                adjustedLastHops = null;
                route.add(this.getSelfIDAddressPair());
                if (msgType != Tag.ITE_ROUTE_JOIN) {
                    StatReporter statReporter = this.receiver.getStatReporter();
                    statReporter.notifyStatCollectorOfEmphasizeNode(this.getSelfIDAddressPair(), this.getSelfIDAddressPair().getID());
                    statReporter.notifyStatCollectorOfMarkedID(this.getSelfIDAddressPair(), dest, 0);
                }
                queryConcurrency = this.config.getQueryConcurrency();
                if (!this.queryToAllContacts || msgType == Tag.ITE_ROUTE_JOIN || queryConcurrency <= 0) {
                    queryConcurrency = 1;
                }
                AbstractContactList abstractContactList = contactList = this.queryToAllContacts ? new SortedContactList(dest, this.algorithm, this.config.getNumOfNodesMaintained()) : new InsertedOrderContactList();
                if (msgType != Tag.ITE_ROUTE_JOIN) {
                    IDAddressPair[] closestNodes;
                    RoutingContext initialRoutingContext = this.algorithm.initialRoutingContext(dest);
                    for (IDAddressPair elem : closestNodes = this.algorithm.closestTo(dest, this.config.getNumOfClosestNodesRequested(), initialRoutingContext)) {
                        if (elem == null) continue;
                        contactList.add(elem, this.getSelfIDAddressPair());
                    }
                }
                lastContact = null;
                callbackResult = null;
                neighbors = this.algorithm.neighbors(numNeighbors);
                if (queryConcurrency > 1) break block44;
                Querier querier = new Querier(false, this.queryToAllContacts, dest, this.config.getNumOfClosestNodesRequested(), numNeighbors, msgType, route, contactList, blackList, joinInitialContact, filter, callbackTag, callbackArgs);
                querier.run();
                contact = contactList.first();
                if (contact == null) break block45;
                if (msgType == Tag.ITE_ROUTE_JOIN && contact.equals(this.getSelfIDAddressPair())) {
                    contactList.remove(contact);
                    contact = contactList.first();
                }
                if (contact == null) break block45;
                lastContact = contactList.getLastContactOf(contact);
                callbackResult = querier.getCallbackResult(contact.getID());
                neighbors = querier.getNeighbors(contact.getID());
                break block45;
            }
            Querier[] queriers = new Querier[queryConcurrency];
            Thread[] querierThreads = null;
            if (!this.config.getUseThreadPool()) {
                querierThreads = new Thread[queryConcurrency];
            }
            for (i = 0; i < queryConcurrency; ++i) {
                Thread t;
                queriers[i] = new Querier(true, this.queryToAllContacts, dest, this.config.getNumOfClosestNodesRequested(), numNeighbors, msgType, route, contactList, blackList, joinInitialContact, filter, callbackTag, callbackArgs);
                if (this.config.getUseThreadPool()) continue;
                querierThreads[i] = t = new Thread(queriers[i]);
                t.setName("Querier " + i);
                t.setDaemon(true);
            }
            if (this.config.getUseThreadPool()) {
                int i2;
                Future[] querierResults = new Future[queryConcurrency];
                for (i2 = 0; i2 < queryConcurrency; ++i2) {
                    querierResults[i2] = this.threadPool.submit(queriers[i2]);
                }
                for (i2 = 0; i2 < queryConcurrency; ++i2) {
                    try {
                        boolean succeed = (Boolean)querierResults[i2].get();
                        continue;
                    }
                    catch (InterruptedException e) {
                        logger.log(Level.WARNING, "A Querier interrupted.", e);
                        continue;
                    }
                    catch (ExecutionException e) {
                        logger.log(Level.WARNING, "A Querier thrown an Exception.", e.getCause());
                    }
                }
            } else {
                for (i = 0; i < queryConcurrency; ++i) {
                    querierThreads[i].start();
                }
                for (i = 0; i < queryConcurrency; ++i) {
                    try {
                        querierThreads[i].join();
                        continue;
                    }
                    catch (InterruptedException e) {
                        logger.log(Level.WARNING, "Interrupted while waiting querying threads.", e);
                    }
                }
            }
            if ((contact = contactList.first()) != null) {
                int i3;
                lastContact = contactList.getLastContactOf(contact);
                for (i3 = 0; i3 < queryConcurrency && (callbackResult = queriers[i3].getCallbackResult(contact.getID())) == null; ++i3) {
                }
                for (i3 = 0; i3 < queryConcurrency && ((neighbors = queriers[i3].getNeighbors(contact.getID())) == null || neighbors.length <= 0); ++i3) {
                }
            }
        }
        if (callbackResult != null) {
            if (resultingCallbackResult != null) {
                resultingCallbackResult[0] = callbackResult;
            }
            logger.log(Level.INFO, "callback result: " + callbackResult);
        }
        if (this.queryToAllContacts) {
            IDAddressPair tailOfRoute = route.get(route.size() - 1);
            if (lastContact != null && !lastContact.equals(this.getSelfIDAddressPair()) && !lastContact.equals(tailOfRoute)) {
                route.add(lastContact);
                tailOfRoute = lastContact;
            }
            if (contact != null && !contact.equals(tailOfRoute)) {
                route.add(contact);
            }
        }
        if (adjustLastHop && contact != null && contact.getID() != null) {
            while (true) {
                if (contact.equals(this.getSelfIDAddressPair())) {
                    adjustedLastHops = this.algorithm.adjustRoot(dest);
                    break;
                }
                Message reqMsg = RoutingDriverMessageFactory.getIteAdjustLastHopReq(this.getSelfIDAddressPair(), dest);
                Message repMsg = null;
                try {
                    repMsg = this.sender.sendAndReceive(contact.getAddress(), reqMsg);
                    Serializable[] contents = repMsg.getContents();
                    adjustedLastHops = (IDAddressPair[])contents[0];
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Failed to send/receive ITE_ADJUST_LAST_HOP_REQ: " + contact.getAddress() + " on " + this.getSelfIDAddressPair().getAddress(), e);
                    contactList.remove(contact);
                    contact = contactList.first();
                    continue;
                }
                break;
            }
            if (adjustedLastHops != null) {
                Message requestMsg = msgType == Tag.ITE_ROUTE_NONE ? RoutingDriverMessageFactory.getIteNoneMessage(this.getSelfIDAddressPair(), numNeighbors) : (msgType == Tag.ITE_ROUTE_INVOKE ? RoutingDriverMessageFactory.getIteInvokeMessage(this.getSelfIDAddressPair(), dest, numNeighbors, filter, callbackTag, callbackArgs, contact) : RoutingDriverMessageFactory.getIteJoinMessage(this.getSelfIDAddressPair(), this.getSelfIDAddressPair(), numNeighbors, contact));
                IDAddressPair[] oldAdjustedLastHops = adjustedLastHops;
                adjustedLastHops = new IDAddressPair[oldAdjustedLastHops.length + 1];
                System.arraycopy(oldAdjustedLastHops, 0, adjustedLastHops, 0, oldAdjustedLastHops.length);
                adjustedLastHops[oldAdjustedLastHops.length] = lastContact;
                Message replyMsg = null;
                boolean adjustSucceeded = false;
                for (IDAddressPair nextHop : adjustedLastHops) {
                    if (nextHop == null || nextHop.equals(contact) || blackList.contains(nextHop.getAddress()) || msgType == Tag.ITE_ROUTE_JOIN && nextHop.equals(this.getSelfIDAddressPair())) continue;
                    try {
                        replyMsg = this.sender.sendAndReceive(nextHop.getAddress(), requestMsg);
                        this.algorithm.touch(replyMsg.getSource());
                        if (replyMsg.getTag() != Tag.ITE_REPLY.getNumber()) {
                            logger.log(Level.SEVERE, "Received message is not ITE_REPLY: " + Tag.getStringByNumber(replyMsg.getTag()));
                            replyMsg = null;
                            break;
                        }
                        route.add(nextHop);
                        adjustSucceeded = true;
                        break;
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Sending or receiving failed: " + nextHop.getAddress() + " on " + this.getSelfIDAddressPair().getAddress());
                        super.fail(nextHop);
                    }
                }
                if (adjustSucceeded && replyMsg != null) {
                    Serializable[] contents = replyMsg.getContents();
                    neighbors = (IDAddressPair[])contents[1];
                    callbackResult = contents[2];
                    if (callbackResult != null) {
                        if (resultingCallbackResult != null) {
                            resultingCallbackResult[0] = callbackResult;
                        }
                        logger.log(Level.INFO, "callback result: " + callbackResult);
                    }
                } else {
                    logger.log(Level.WARNING, "Failed to contact all candidates for the true last hop.");
                }
            }
        }
        boolean isRootNode = this.getSelfIDAddressPair().equals(route.get(route.size() - 1));
        if (msgType == Tag.ITE_ROUTE_INVOKE) {
            callbackResult = this.invokeCallbacks(dest, filter, callbackTag, callbackArgs, null, isRootNode);
            if (isRootNode && resultingCallbackResult != null) {
                resultingCallbackResult[0] = callbackResult;
            }
        }
        if (msgType == Tag.ITE_ROUTE_JOIN) {
            this.algorithm.join(this.getSelfIDAddressPair(), null, isRootNode);
        }
        IDAddressPair[] routeArray = new IDAddressPair[route.size()];
        route.toArray(routeArray);
        return new RoutingResult(routeArray, neighbors);
    }

    private void prepareHandlers() {
        MessageHandler handler = new MessageHandler(){

            public Message process(Message msg) {
                boolean isRootNode;
                boolean routing;
                ID target;
                int numClosestNodes = 1;
                int numNeighbors = 1;
                RoutingContext routingContext = null;
                CallbackResultFilter filter = null;
                int tag = -1;
                Serializable[] args = null;
                IDAddressPair lastHop = null;
                IDAddressPair joiningNode = null;
                Serializable[] contents = msg.getContents();
                if (msg.getTag() == Tag.ITE_ROUTE_NONE.getNumber()) {
                    target = (ID)contents[0];
                    numClosestNodes = (Integer)contents[1];
                    numNeighbors = (Integer)contents[2];
                    routingContext = (RoutingContext)contents[3];
                    routing = true;
                } else if (msg.getTag() == Tag.ITE_ROUTE_INVOKE.getNumber()) {
                    target = (ID)contents[0];
                    numClosestNodes = (Integer)contents[1];
                    numNeighbors = (Integer)contents[2];
                    routingContext = (RoutingContext)contents[3];
                    filter = (CallbackResultFilter)contents[4];
                    tag = (Integer)contents[5];
                    args = (Serializable[])contents[6];
                    lastHop = (IDAddressPair)contents[7];
                    routing = true;
                } else if (msg.getTag() == Tag.ITE_ROUTE_JOIN.getNumber()) {
                    joiningNode = (IDAddressPair)contents[0];
                    target = joiningNode.getID();
                    numClosestNodes = (Integer)contents[1];
                    numNeighbors = (Integer)contents[2];
                    routingContext = (RoutingContext)contents[3];
                    lastHop = (IDAddressPair)contents[4];
                    routing = true;
                } else if (msg.getTag() == Tag.ITE_NONE.getNumber()) {
                    target = null;
                    numNeighbors = (Integer)contents[0];
                    routing = false;
                } else if (msg.getTag() == Tag.ITE_INVOKE.getNumber()) {
                    target = (ID)contents[0];
                    numNeighbors = (Integer)contents[1];
                    filter = (CallbackResultFilter)contents[2];
                    tag = (Integer)contents[3];
                    args = (Serializable[])contents[4];
                    lastHop = (IDAddressPair)contents[5];
                    routing = false;
                } else {
                    joiningNode = (IDAddressPair)contents[0];
                    target = joiningNode.getID();
                    numNeighbors = (Integer)contents[1];
                    lastHop = (IDAddressPair)contents[2];
                    routing = false;
                }
                IDAddressPair[] closestNodes = null;
                IDAddressPair[] adjustedLastHops = null;
                if (routing) {
                    if (routingContext == null) {
                        routingContext = IterativeRoutingDriver.this.algorithm.initialRoutingContext(target);
                    }
                    boolean bl = isRootNode = (closestNodes = IterativeRoutingDriver.this.algorithm.closestTo(target, numClosestNodes, routingContext))[0] != null && closestNodes[0].equals(IterativeRoutingDriver.this.getSelfIDAddressPair());
                    if (isRootNode && (adjustedLastHops = IterativeRoutingDriver.this.algorithm.adjustRoot(target)) != null) {
                        isRootNode = adjustedLastHops[0].equals(IterativeRoutingDriver.this.getSelfIDAddressPair());
                    }
                } else {
                    isRootNode = true;
                }
                IterativeRoutingDriver.this.algorithm.touch(msg.getSource());
                Serializable callbackResult = null;
                if (msg.getTag() == Tag.ITE_ROUTE_INVOKE.getNumber() || msg.getTag() == Tag.ITE_INVOKE.getNumber()) {
                    callbackResult = IterativeRoutingDriver.this.invokeCallbacks(target, filter, tag, args, lastHop, isRootNode);
                    if (callbackResult != null) {
                        AbstractRoutingDriver.logger.log(Level.INFO, "A callback returned non-null object: " + callbackResult);
                    }
                } else if (msg.getTag() == Tag.ITE_ROUTE_JOIN.getNumber() || msg.getTag() == Tag.ITE_JOIN.getNumber()) {
                    final IDAddressPair copiedJoiningNode = joiningNode;
                    final IDAddressPair copiedLastHop = lastHop;
                    final boolean copiedIsRootNode = isRootNode;
                    Runnable r = new Runnable(){

                        public void run() {
                            IterativeRoutingDriver.this.algorithm.join(copiedJoiningNode, copiedLastHop, copiedIsRootNode);
                        }
                    };
                    if (IterativeRoutingDriver.this.config.getUseThreadPool()) {
                        IterativeRoutingDriver.this.threadPool.submit(r);
                    } else {
                        Thread t = new Thread(r);
                        t.setName("Message type specific processes");
                        t.setDaemon(true);
                        t.start();
                    }
                }
                IDAddressPair[] neighbors = IterativeRoutingDriver.this.algorithm.neighbors(numNeighbors);
                return RoutingDriverMessageFactory.getIteReplyMessage(IterativeRoutingDriver.this.getSelfIDAddressPair(), closestNodes, neighbors, callbackResult);
            }
        };
        this.addMessageHandler(Tag.ITE_ROUTE_NONE.getNumber(), handler);
        this.addMessageHandler(Tag.ITE_ROUTE_INVOKE.getNumber(), handler);
        this.addMessageHandler(Tag.ITE_ROUTE_JOIN.getNumber(), handler);
        this.addMessageHandler(Tag.ITE_NONE.getNumber(), handler);
        this.addMessageHandler(Tag.ITE_INVOKE.getNumber(), handler);
        this.addMessageHandler(Tag.ITE_JOIN.getNumber(), handler);
        handler = new MessageHandler(){

            public Message process(Message msg) {
                Serializable[] contents = msg.getContents();
                ID target = (ID)contents[0];
                IDAddressPair[] adjustedLastHops = IterativeRoutingDriver.this.algorithm.adjustRoot(target);
                Message repMsg = RoutingDriverMessageFactory.getIteAdjustLastHopRep(IterativeRoutingDriver.this.getSelfIDAddressPair(), adjustedLastHops);
                return repMsg;
            }
        };
        this.addMessageHandler(Tag.ITE_ADJUST_LAST_HOP_REQ.getNumber(), handler);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Querier
    implements Runnable,
    Callable<Boolean> {
        private boolean concurrent;
        private boolean queryToAllContacts;
        private ID target;
        private int numClosestNodes;
        private int numNeighbors;
        private Tag msgType;
        private final List<IDAddressPair> route;
        private ContactList contactList;
        private Set<MessagingAddress> blackList;
        private MessagingAddress joinInitialContact;
        private CallbackResultFilter filter;
        private int callbackTag;
        private Serializable[] callbackArgs;
        private Map<ID, Serializable> callbackResultTable = new HashMap<ID, Serializable>();
        private Map<ID, IDAddressPair[]> neighborTable = new HashMap<ID, IDAddressPair[]>();

        Querier(boolean concurrent, boolean queryToAllContacts, ID target, int numClosestNodes, int numNeighbors, Tag msgType, List<IDAddressPair> route, ContactList contactList, Set<MessagingAddress> blackList, MessagingAddress joinInitialContact, CallbackResultFilter filter, int callbackTag, Serializable[] callbackArgs) {
            this.concurrent = concurrent;
            this.queryToAllContacts = queryToAllContacts;
            this.target = target;
            this.numClosestNodes = numClosestNodes;
            this.numNeighbors = numNeighbors;
            this.msgType = msgType;
            this.route = route;
            this.contactList = contactList;
            this.blackList = blackList;
            this.joinInitialContact = joinInitialContact;
            this.filter = filter;
            this.callbackTag = callbackTag;
            this.callbackArgs = callbackArgs;
        }

        @Override
        public void run() {
            try {
                this.call();
            }
            catch (Exception e) {
                AbstractRoutingDriver.logger.log(Level.SEVERE, "A Querier thrown an exception.", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            block32: {
                IDAddressPair contact;
                IDAddressPair lastContact = IterativeRoutingDriver.this.getSelfIDAddressPair();
                IDAddressPair[] closestNodes = null;
                IDAddressPair[] neighbors = null;
                int ttl = IterativeRoutingDriver.this.config.getTTL();
                if (this.msgType == Tag.ITE_ROUTE_JOIN) {
                    contact = new IDAddressPair(null, this.joinInitialContact);
                } else {
                    IDAddressPair iDAddressPair = contact = this.queryToAllContacts ? this.contactList.firstExceptContactedNode() : this.contactList.first();
                    if (contact == null) {
                        return false;
                    }
                }
                do {
                    if (ttl-- <= 0) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("TTL expired:");
                        for (IDAddressPair n : this.route) {
                            sb.append(" ");
                            sb.append(n.getAddress());
                        }
                        AbstractRoutingDriver.logger.log(Level.WARNING, sb.toString(), new Exception());
                        break;
                    }
                    Message replyMsg = null;
                    do {
                        RoutingContext cxt;
                        if (this.msgType == Tag.ITE_ROUTE_JOIN && this.target.equals(contact.getID())) {
                            this.contactList.remove(contact);
                            IDAddressPair iDAddressPair = contact = this.queryToAllContacts ? this.contactList.firstExceptContactedNode() : this.contactList.first();
                            if (contact != null && !lastContact.equals(contact)) continue;
                            break block32;
                        }
                        if (contact.getID() != null && IterativeRoutingDriver.this.getSelfIDAddressPair().equals(contact)) {
                            if (this.msgType == Tag.ITE_ROUTE_INVOKE && !IterativeRoutingDriver.this.getSelfIDAddressPair().equals(lastContact)) {
                                boolean isRootNode = false;
                                if (closestNodes != null) {
                                    isRootNode = IterativeRoutingDriver.this.getSelfIDAddressPair().equals(closestNodes[0]);
                                }
                                Serializable callbackResult = IterativeRoutingDriver.this.invokeCallbacks(this.target, this.filter, this.callbackTag, this.callbackArgs, lastContact, isRootNode);
                                this.setCallbackResult(IterativeRoutingDriver.this.getSelfIDAddressPair().getID(), callbackResult);
                            }
                            neighbors = IterativeRoutingDriver.this.algorithm.neighbors(this.numNeighbors);
                            this.setNeighbors(IterativeRoutingDriver.this.getSelfIDAddressPair().getID(), neighbors);
                            if (contact.equals(IterativeRoutingDriver.this.getSelfIDAddressPair())) break block32;
                            cxt = null;
                            try {
                                cxt = ((IDAddressRoutingContextTriplet)contact).getRoutingContext();
                            }
                            catch (ClassCastException e) {
                                // empty catch block
                            }
                            if (cxt == null) {
                                cxt = IterativeRoutingDriver.this.algorithm.initialRoutingContext(this.target);
                            }
                            closestNodes = IterativeRoutingDriver.this.algorithm.closestTo(this.target, this.numClosestNodes, cxt);
                            break;
                        }
                        replyMsg = null;
                        try {
                            cxt = null;
                            try {
                                cxt = ((IDAddressRoutingContextTriplet)contact).getRoutingContext();
                            }
                            catch (ClassCastException e) {
                                // empty catch block
                            }
                            Message requestMsg = null;
                            requestMsg = this.msgType == Tag.ITE_ROUTE_NONE ? RoutingDriverMessageFactory.getIteRouteNoneMessage(IterativeRoutingDriver.this.getSelfIDAddressPair(), this.target, IterativeRoutingDriver.this.config.getNumOfClosestNodesRequested(), this.numNeighbors, cxt) : (this.msgType == Tag.ITE_ROUTE_INVOKE ? RoutingDriverMessageFactory.getIteRouteInvokeMessage(IterativeRoutingDriver.this.getSelfIDAddressPair(), this.target, IterativeRoutingDriver.this.config.getNumOfClosestNodesRequested(), this.numNeighbors, cxt, this.filter, this.callbackTag, this.callbackArgs, lastContact) : RoutingDriverMessageFactory.getIteRouteJoinMessage(IterativeRoutingDriver.this.getSelfIDAddressPair(), IterativeRoutingDriver.this.getSelfIDAddressPair(), IterativeRoutingDriver.this.config.getNumOfClosestNodesRequested(), this.numNeighbors, cxt, lastContact));
                            replyMsg = IterativeRoutingDriver.this.sender.sendAndReceive(contact.getAddress(), requestMsg);
                            IDAddressPair iDAddressPair = contact;
                            synchronized (iDAddressPair) {
                                if (contact.getID() == null) {
                                    contact.setID(replyMsg.getSource().getID());
                                    this.contactList.addAsContacted(contact, lastContact);
                                }
                            }
                            IterativeRoutingDriver.this.algorithm.touch(replyMsg.getSource());
                            if (replyMsg.getTag() != Tag.ITE_REPLY.getNumber()) {
                                AbstractRoutingDriver.logger.log(Level.SEVERE, "Received message is not ITE_REPLY: " + Tag.getStringByNumber(replyMsg.getTag()));
                                replyMsg = null;
                                break;
                            }
                            Serializable[] contents = replyMsg.getContents();
                            closestNodes = (IDAddressPair[])contents[0];
                            neighbors = (IDAddressPair[])contents[1];
                            Serializable callbackResult = contents[2];
                            this.setNeighbors(contact.getID(), neighbors);
                            this.setCallbackResult(contact.getID(), callbackResult);
                            break;
                        }
                        catch (IOException e) {
                            AbstractRoutingDriver.logger.log(Level.WARNING, "Sending or receiving failed: " + contact.getAddress() + " on " + IterativeRoutingDriver.this.getSelfIDAddressPair().getAddress());
                            if (contact.getID() != null) {
                                IterativeRoutingDriver.super.fail(contact);
                                this.blackList.add(contact.getAddress());
                            }
                            this.contactList.remove(contact);
                            IDAddressPair iDAddressPair = contact = this.queryToAllContacts ? this.contactList.firstExceptContactedNode() : this.contactList.first();
                            if (contact != null) continue;
                            if (this.concurrent) break block32;
                            AbstractRoutingDriver.logger.log(Level.WARNING, "Failed to send to any node.");
                            break block32;
                        }
                    } while (replyMsg == null);
                    if (!this.queryToAllContacts) {
                        this.route.add(contact);
                    }
                    if (this.msgType == Tag.ITE_ROUTE_JOIN && closestNodes != null && closestNodes.length >= 1 && closestNodes[0].equals(IterativeRoutingDriver.this.getSelfIDAddressPair())) {
                        closestNodes = null;
                    }
                    if (closestNodes != null) {
                        ContactList contactList = this.contactList;
                        synchronized (contactList) {
                            IDAddressPair p;
                            if (!this.queryToAllContacts) {
                                this.contactList.clear();
                            }
                            for (int i = 0; i < closestNodes.length && (p = closestNodes[i]) != null; ++i) {
                                if (this.blackList.contains(p.getAddress())) continue;
                                this.contactList.add(p, contact);
                            }
                        }
                    }
                    lastContact = contact;
                    IDAddressPair iDAddressPair = contact = this.queryToAllContacts ? this.contactList.firstExceptContactedNode() : this.contactList.first();
                } while (contact != null && !lastContact.equals(contact));
            }
            return true;
        }

        public Serializable getCallbackResult(ID node) {
            return this.callbackResultTable.get(node);
        }

        public void setCallbackResult(ID node, Serializable o) {
            this.callbackResultTable.put(node, o);
        }

        public IDAddressPair[] getNeighbors(ID node) {
            return this.neighborTable.get(node);
        }

        public void setNeighbors(ID node, IDAddressPair[] n) {
            this.neighborTable.put(node, n);
        }
    }
}

