/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.messaging.MessageSender;
import ow.routing.RoutingAlgorithm;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingContext;
import ow.routing.RoutingRuntime;
import ow.routing.RoutingService;
import ow.routing.RoutingServiceConfiguration;
import ow.routing.impl.AbstractRoutingDriver;

public abstract class AbstractRoutingAlgorithm
implements RoutingAlgorithm {
    protected static final Logger logger = Logger.getLogger("routing");
    protected IDAddressPair selfIDAddress;
    protected RoutingAlgorithmConfiguration config;
    protected RoutingRuntime runtime;
    protected RoutingServiceConfiguration runtimeConfig;
    protected MessageSender sender;
    private FailureTable failureTable;

    public AbstractRoutingAlgorithm(RoutingAlgorithmConfiguration config, RoutingService routingSvc) {
        this.config = config;
        this.runtime = (RoutingRuntime)((Object)routingSvc);
        this.runtimeConfig = this.runtime.getConfiguration();
        this.sender = this.runtime.getMessageSender();
        if (routingSvc != null) {
            this.selfIDAddress = routingSvc.getSelfIDAddressPair();
            ((AbstractRoutingDriver)routingSvc).setRoutingAlgorithm(this);
        }
        this.failureTable = new FailureTable(this.config.getFailureExpiration());
    }

    public RoutingContext initialRoutingContext(ID target) {
        return null;
    }

    public final void fail(IDAddressPair failedNode) {
        int numOfFailures = this.failureTable.register(failedNode);
        String additionalMsg = "";
        if (numOfFailures >= this.config.getNumOfFailuresBeforeForgetNode()) {
            this.forget(failedNode);
            additionalMsg = ", and forget it";
        }
        logger.log(Level.WARNING, "RoutingAlgorithm#fail: " + failedNode.getAddress() + " on " + this.selfIDAddress.getAddress() + " " + numOfFailures + " time" + (numOfFailures > 1 ? "s" : "") + additionalMsg + ".");
    }

    private static final class FailureTable {
        private static final int GC_FREQ = 100;
        private int gcCountdown = 100;
        private long expiration;
        private Map<IDAddressPair, Long> lastFailedTimeTable;
        private Map<IDAddressPair, Integer> numOfTimesTable;

        FailureTable(long expiration) {
            this.expiration = expiration;
            this.numOfTimesTable = new HashMap<IDAddressPair, Integer>();
            this.lastFailedTimeTable = new HashMap<IDAddressPair, Long>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int register(IDAddressPair node) {
            int numOfTimes;
            long currentTime = System.currentTimeMillis();
            FailureTable failureTable = this;
            synchronized (failureTable) {
                Long lastTimeObj = this.lastFailedTimeTable.get(node);
                long lastTime = lastTimeObj == null ? 0L : lastTimeObj;
                Integer numOfTimesObj = this.numOfTimesTable.get(node);
                int n = numOfTimes = numOfTimesObj == null ? 0 : numOfTimesObj;
                if (currentTime >= lastTime + this.expiration) {
                    numOfTimes = 0;
                }
                this.lastFailedTimeTable.put(node, currentTime);
                this.numOfTimesTable.put(node, ++numOfTimes);
                if (--this.gcCountdown <= 0) {
                    this.gcCountdown = 100;
                    Set<Map.Entry<IDAddressPair, Long>> entrySet = this.lastFailedTimeTable.entrySet();
                    Map.Entry[] entryArray = new Map.Entry[entrySet.size()];
                    entrySet.toArray(entryArray);
                    for (Map.Entry e : entryArray) {
                        lastTime = (Long)e.getValue();
                        if (currentTime < lastTime + this.expiration) continue;
                        IDAddressPair idAddr = (IDAddressPair)e.getKey();
                        this.lastFailedTimeTable.remove(idAddr);
                        this.numOfTimesTable.remove(idAddr);
                    }
                }
            }
            return numOfTimes;
        }
    }
}

