/*
 * Decompiled with CFR 0.152.
 */
package ow.msgstat.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.messaging.Message;
import ow.messaging.MessageHandler;
import ow.messaging.MessageReceiver;
import ow.messaging.MessagingAddress;
import ow.messaging.MessagingFactory;
import ow.messaging.MessagingProvider;
import ow.messaging.Signature;
import ow.messaging.Tag;
import ow.msgstat.CallbackOnNodeRelationship;
import ow.msgstat.CallbackOnNodeStatus;
import ow.msgstat.StatCollector;
import ow.msgstat.StatCollectorConfiguration;
import ow.msgstat.impl.StatCollectorMessageFactory;

public class StatCollectorImpl
implements StatCollector {
    private static final Logger logger = Logger.getLogger("statcollector");
    private final StatCollectorConfiguration config;
    private MessagingProvider provider;
    private MessageReceiver receiver;
    private IDAddressPair selfIDAddress;
    private CallbackOnNodeStatus callback;
    private final Map<MessagingAddress, ID> idTable = new HashMap<MessagingAddress, ID>();

    public StatCollectorImpl(StatCollectorConfiguration config) throws Exception {
        this.config = config;
        this.provider = MessagingFactory.getProvider(this.config.getMessagingType(), Signature.getAllAcceptingSignature());
        if (this.config.getSelfAddress() != null) {
            this.provider.setDefaultSelfAddress(this.config.getSelfAddress());
        }
        this.receiver = this.provider.getReceiver(this.provider.getDefaultConfiguration(), this.config.getSelfPort(), this.config.getSelfPortRange());
        this.selfIDAddress = new IDAddressPair(null, this.receiver.getSelfAddress());
    }

    public void start(CallbackOnNodeStatus callback) throws IOException {
        this.callback = callback;
        this.prepareHandlers();
    }

    public void stop() {
        if (this.receiver != null) {
            this.receiver.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ID getID(MessagingAddress address) {
        ID id = null;
        Map<MessagingAddress, ID> map = this.idTable;
        synchronized (map) {
            id = this.idTable.get(address);
        }
        return id;
    }

    public MessagingProvider getMessagingProvider() {
        return this.provider;
    }

    public MessageReceiver getMessageReceiver() {
        return this.receiver;
    }

    private void prepareHandlers() {
        MessageHandler handler = new MessageHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Message process(Message msg) {
                Message ret = null;
                Serializable[] contents = msg.getContents();
                int msgTag = msg.getTag();
                if (msgTag == Tag.STAT_PING.getNumber()) {
                    ret = StatCollectorMessageFactory.getStatAckMessage(StatCollectorImpl.this.selfIDAddress);
                } else if (msgTag == Tag.MESSAGE_SENT.getNumber()) {
                    MessagingAddress src = (MessagingAddress)contents[0];
                    MessagingAddress dest = (MessagingAddress)contents[1];
                    int tag = (Integer)contents[2];
                    IDAddressPair source = msg.getSource();
                    MessagingAddress addr = source.getAddress();
                    ID id = source.getID();
                    if (id != null) {
                        Map map = StatCollectorImpl.this.idTable;
                        synchronized (map) {
                            ID oldID = (ID)StatCollectorImpl.this.idTable.get(addr);
                            if (oldID == null || !oldID.equals(id)) {
                                StatCollectorImpl.this.idTable.put(addr, id);
                            }
                        }
                    }
                    StatCollectorImpl.this.callback.messageSent(src, dest, tag);
                } else if (msgTag == Tag.DELETE_NODE.getNumber()) {
                    MessagingAddress node = (MessagingAddress)contents[0];
                    StatCollectorImpl.this.callback.deleteNode(node);
                } else if (StatCollectorImpl.this.callback instanceof CallbackOnNodeRelationship) {
                    CallbackOnNodeRelationship cb = (CallbackOnNodeRelationship)StatCollectorImpl.this.callback;
                    if (msgTag == Tag.EMPHASIZE_NODE.getNumber()) {
                        ID nodeID = (ID)contents[0];
                        cb.emphasizeNode(nodeID);
                    } else if (msgTag == Tag.MARK_ID.getNumber()) {
                        ID id = (ID)contents[0];
                        int hint = (Integer)contents[1];
                        cb.markID(id, hint);
                    } else if (msgTag == Tag.CONNECT_NODES.getNumber()) {
                        ID from = (ID)contents[0];
                        ID to = (ID)contents[1];
                        int colorHint = (Integer)contents[2];
                        cb.connectNodes(from, to, colorHint);
                    } else if (msgTag == Tag.DISCONNECT_NODES.getNumber()) {
                        ID from = (ID)contents[0];
                        ID to = (ID)contents[1];
                        int colorHint = (Integer)contents[2];
                        cb.disconnectNodes(from, to, colorHint);
                    }
                }
                return ret;
            }
        };
        this.receiver.addHandler(handler);
    }
}

