/*
 * Decompiled with CFR 0.152.
 */
package ow.msgstat;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.messaging.Message;
import ow.messaging.MessageSender;
import ow.messaging.MessagingAddress;
import ow.messaging.MessagingProvider;
import ow.messaging.Tag;
import ow.msgstat.StatCollectorConfiguration;
import ow.msgstat.impl.StatCollectorMessageFactory;
import ow.tool.util.vizframework.VisualizerMessageFactory;

public final class StatReporter {
    private static final Logger logger = Logger.getLogger("statcollector");
    private final StatCollectorConfiguration config;
    private final MessagingProvider provider;
    private final MessageSender sender;
    private final int pingFreq;
    private int notificationCount;
    private int failureCount;

    StatReporter(StatCollectorConfiguration config, MessagingProvider provider, MessageSender sender) {
        this.config = config;
        this.provider = provider;
        this.sender = sender;
        this.pingFreq = this.config.getPingFrequency();
        this.notificationCount = 0;
        this.failureCount = 0;
        this.sender.setStatReporter(this);
    }

    public void notifyStatCollectorOfMessageSent(MessagingAddress dest, Message msg) {
        IDAddressPair self;
        MessagingAddress statCollectorAddress;
        block4: {
            statCollectorAddress = this.provider.getStatCollectorAddress();
            if (statCollectorAddress == null) {
                return;
            }
            int tag = msg.getTag();
            if (!Tag.toBeReportedToStatCollector(tag)) {
                return;
            }
            self = msg.getSource();
            Message notifyMsg = StatCollectorMessageFactory.getMessageSentMessage(self, self.getAddress(), dest, tag);
            try {
                this.sender.send(statCollectorAddress, notifyMsg);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to send a MESSGAGE_SENT message.", e);
                if (!this.failInReporting()) break block4;
                return;
            }
        }
        this.confirmAlive(statCollectorAddress, self);
    }

    public void notifyStatCollectorOfDeletedNode(IDAddressPair self, MessagingAddress failedNode, int tag) {
        MessagingAddress statCollectorAddress;
        block4: {
            statCollectorAddress = this.provider.getStatCollectorAddress();
            if (statCollectorAddress == null) {
                return;
            }
            if (!Tag.toBeReportedToStatCollector(tag)) {
                return;
            }
            Message notifyMsg = StatCollectorMessageFactory.getDeleteNodeMessage(self, failedNode);
            try {
                this.sender.send(statCollectorAddress, notifyMsg);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to send a DELETE message.", e);
                if (!this.failInReporting()) break block4;
                return;
            }
        }
        this.confirmAlive(statCollectorAddress, self);
    }

    public void notifyStatCollectorOfEmphasizeNode(IDAddressPair self, ID nodeID) {
        MessagingAddress statCollectorAddress;
        block3: {
            statCollectorAddress = this.provider.getStatCollectorAddress();
            if (statCollectorAddress == null) {
                return;
            }
            Message msg = VisualizerMessageFactory.getEmphasizeNodeMessage(self, nodeID);
            try {
                this.sender.send(statCollectorAddress, msg);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to send a EMPHASIZE_NODE message.", e);
                if (!this.failInReporting()) break block3;
                return;
            }
        }
        this.confirmAlive(statCollectorAddress, self);
    }

    public void notifyStatCollectorOfMarkedID(IDAddressPair self, ID id, int hint) {
        MessagingAddress statCollectorAddress;
        block3: {
            statCollectorAddress = this.provider.getStatCollectorAddress();
            if (statCollectorAddress == null) {
                return;
            }
            Message msg = VisualizerMessageFactory.getMarkIDMessage(self, id, hint);
            try {
                this.sender.send(statCollectorAddress, msg);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to send a MARK_ID message.", e);
                if (!this.failInReporting()) break block3;
                return;
            }
        }
        this.confirmAlive(statCollectorAddress, self);
    }

    public void notifyStatCollectorOfConnectNodes(IDAddressPair self, ID child, ID parent, int colorHint) {
        MessagingAddress statCollectorAddress;
        block3: {
            statCollectorAddress = this.provider.getStatCollectorAddress();
            if (statCollectorAddress == null) {
                return;
            }
            Message msg = StatCollectorMessageFactory.getConnectNodesMessage(self, child, parent, colorHint);
            try {
                this.sender.send(statCollectorAddress, msg);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to send a CONNECT_NODES message.", e);
                if (!this.failInReporting()) break block3;
                return;
            }
        }
        this.confirmAlive(statCollectorAddress, self);
    }

    public void notifyStatCollectorOfDisconnectNodes(IDAddressPair self, ID child, ID parent, int colorHint) {
        MessagingAddress statCollectorAddress;
        block3: {
            statCollectorAddress = this.provider.getStatCollectorAddress();
            if (statCollectorAddress == null) {
                return;
            }
            Message msg = StatCollectorMessageFactory.getDisconnectNodesMessage(self, child, parent, colorHint);
            try {
                this.sender.send(statCollectorAddress, msg);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to send a DISCONNECT_NODES message.", e);
                if (!this.failInReporting()) break block3;
                return;
            }
        }
        this.confirmAlive(statCollectorAddress, self);
    }

    private void confirmAlive(MessagingAddress statCollectorAddress, IDAddressPair self) {
        if (this.provider.isReliable() || ++this.notificationCount % this.pingFreq != 0) {
            return;
        }
        Message pingMessage = StatCollectorMessageFactory.getStatPingMessage(self);
        Message ackMessage = null;
        try {
            ackMessage = this.sender.sendAndReceive(statCollectorAddress, pingMessage);
            if (ackMessage.getTag() == Tag.STAT_ACK.getNumber()) {
                this.failureCount = 0;
                return;
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "STAT_PING failed: " + statCollectorAddress);
        }
        this.failInReporting();
    }

    private boolean failInReporting() {
        boolean toForget = false;
        if (++this.failureCount >= this.config.getNumOfFailuresBeforeForgetCollector()) {
            toForget = true;
            this.failureCount = 0;
        }
        if (toForget) {
            logger.log(Level.WARNING, "Forget a stat collector.");
            this.provider.setStatCollectorAddress(null);
        }
        return toForget;
    }
}

