/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging.tcp;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.messaging.Message;
import ow.messaging.MessageSender;
import ow.messaging.MessagingAddress;
import ow.messaging.Tag;
import ow.messaging.tcp.ConnectionPool;
import ow.messaging.tcp.TCPMessagingAddress;
import ow.messaging.tcp.TCPMessagingProvider;
import ow.messaging.timeoutcalc.TimeoutCalculator;
import ow.msgstat.StatReporter;
import ow.util.Timer;

public class TCPMessageSender
implements MessageSender {
    private static final Logger logger = Logger.getLogger("messaging");
    protected final ConnectionPool connPool;
    private final TCPMessagingProvider provider;
    private final TCPMessagingAddress selfAddress;
    private final TimeoutCalculator timeoutCalc;
    private StatReporter statReporter;

    protected TCPMessageSender(ConnectionPool connPool, TCPMessagingProvider provider, TCPMessagingAddress selfAddr, StatReporter statReporter) {
        this.connPool = connPool;
        this.provider = provider;
        this.selfAddress = selfAddr;
        this.timeoutCalc = provider.getTimeoutCalculator();
        this.statReporter = statReporter;
    }

    public void setStatReporter(StatReporter statReporter) {
        this.statReporter = statReporter;
    }

    public void send(MessagingAddress dest, Message msg) throws IOException {
        this.adjustLoopbackAddress((TCPMessagingAddress)dest);
        InetSocketAddress sockAddr = ((TCPMessagingAddress)dest).getInetSocketAddress();
        SocketChannel sock = null;
        sock = this.connPool.get(sockAddr);
        this.send(sock, dest, msg);
        this.connPool.put(sockAddr, sock);
    }

    private void send(SocketChannel sock, MessagingAddress dest, Message msg) throws IOException {
        logger.log(Level.INFO, "send(" + dest + ", " + Tag.getStringByNumber(msg.getTag()) + ")");
        byte[] sig = this.provider.getMessageSignature();
        msg.setSignature(sig);
        try {
            Message.encode(sock, msg);
            if (this.statReporter != null) {
                this.statReporter.notifyStatCollectorOfMessageSent(dest, msg);
            }
        }
        catch (IOException e) {
            if (this.statReporter != null) {
                this.statReporter.notifyStatCollectorOfDeletedNode(msg.getSource(), dest, msg.getTag());
            }
            throw e;
        }
    }

    public Message sendAndReceive(MessagingAddress dest, Message msg) throws IOException {
        this.adjustLoopbackAddress((TCPMessagingAddress)dest);
        InetSocketAddress sockAddr = ((TCPMessagingAddress)dest).getInetSocketAddress();
        SocketChannel sock = null;
        Message ret = null;
        try {
            sock = this.connPool.get(sockAddr);
        }
        catch (ConnectException e) {
            logger.log(Level.INFO, "Failed to connect: " + dest);
            if (this.statReporter != null) {
                this.statReporter.notifyStatCollectorOfDeletedNode(msg.getSource(), dest, msg.getTag());
            }
            throw e;
        }
        long timeout = this.timeoutCalc.calculateTimeout(dest);
        long start = System.currentTimeMillis();
        this.send(sock, dest, msg);
        try {
            Timer.setTimer(timeout);
            ret = Message.decode(sock);
            Timer.clearTimer();
            this.connPool.put(sockAddr, sock);
            this.timeoutCalc.updateRTT(dest, (int)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            Thread.interrupted();
            logger.log(Level.INFO, "Timeout: " + timeout + " msec.");
            if (this.statReporter != null) {
                this.statReporter.notifyStatCollectorOfDeletedNode(msg.getSource(), dest, msg.getTag());
            }
            throw new IOException("Timeout:" + timeout + " msec.");
        }
        return ret;
    }

    private void adjustLoopbackAddress(TCPMessagingAddress dest) {
        if (dest.getInetAddress().isLoopbackAddress()) {
            dest.setInetAddress(this.selfAddress.getInetAddress());
            logger.log(Level.INFO, "destination is loopback address and adjusted to " + dest);
        }
    }
}

