/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.id.IDAddressPair;
import ow.messaging.Message;
import ow.messaging.MessageHandler;
import ow.messaging.MessageReceiver;
import ow.messaging.MessageSender;
import ow.messaging.MessagingAddress;
import ow.messaging.Signature;
import ow.messaging.tcp.ConnectionPool;
import ow.messaging.tcp.TCPMessageSender;
import ow.messaging.tcp.TCPMessagingAddress;
import ow.messaging.tcp.TCPMessagingConfiguration;
import ow.messaging.tcp.TCPMessagingProvider;
import ow.msgstat.StatCollectorConfiguration;
import ow.msgstat.StatCollectorFactory;
import ow.msgstat.StatReporter;

public class TCPMessageReceiver
implements MessageReceiver,
Runnable {
    private static final Logger logger = Logger.getLogger("messaging");
    private TCPMessagingAddress selfAddr;
    private ServerSocketChannel servSock;
    private TCPMessagingConfiguration config;
    private TCPMessagingProvider provider;
    private ConnectionPool connPool;
    private TCPMessageSender sender;
    private Thread receiverThread;
    private Set<Thread> handlerThreads = Collections.synchronizedSet(new HashSet());
    private List<MessageHandler> handlerList = Collections.synchronizedList(new ArrayList());
    private final StatReporter statReporter;

    protected TCPMessageReceiver(InetAddress selfInetAddr, int port, int portRange, TCPMessagingConfiguration config, TCPMessagingProvider provider) throws IOException {
        this.config = config;
        this.provider = provider;
        this.servSock = ServerSocketChannel.open();
        if (selfInetAddr == null) {
            selfInetAddr = InetAddress.getLocalHost();
        }
        ServerSocket s = this.servSock.socket();
        s.setReuseAddress(true);
        boolean bound = false;
        if (portRange <= 0) {
            portRange = 1;
        }
        for (int i = 0; i < portRange; ++i) {
            this.selfAddr = new TCPMessagingAddress(selfInetAddr, port + i);
            try {
                s.bind(this.selfAddr.getInetSocketAddress());
                bound = true;
                break;
            }
            catch (IOException e) {
                continue;
            }
        }
        if (!bound) {
            logger.log(Level.SEVERE, "Could not bind to " + this.selfAddr.getInetSocketAddress() + "." + " Specify self hostname with -s option.");
            throw new IOException("Bind failed: " + this.selfAddr.getInetSocketAddress());
        }
        this.connPool = new ConnectionPool(config.getConnectionPoolSize());
        StatCollectorConfiguration conf = StatCollectorFactory.getDefaultConfiguration();
        this.statReporter = StatCollectorFactory.getStatReporter(conf, this.provider, this.getSender());
        this.sender = (TCPMessageSender)this.getSender();
    }

    public MessagingAddress getSelfAddress() {
        return this.selfAddr;
    }

    public int getPort() {
        return this.selfAddr.getPort();
    }

    public StatReporter getStatReporter() {
        return this.statReporter;
    }

    public MessageSender getSender() {
        return new TCPMessageSender(this.connPool, this.provider, this.selfAddr, this.statReporter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        TCPMessageReceiver tCPMessageReceiver = this;
        synchronized (tCPMessageReceiver) {
            if (this.receiverThread == null) {
                this.receiverThread = new Thread(this);
                this.receiverThread.setDaemon(true);
                this.receiverThread.setName("TCPMessageReceiver");
                this.receiverThread.setPriority(Thread.currentThread().getPriority() + 1);
                this.receiverThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        TCPMessageReceiver tCPMessageReceiver = this;
        synchronized (tCPMessageReceiver) {
            if (this.receiverThread != null) {
                this.receiverThread.interrupt();
                this.receiverThread = null;
            }
        }
        Thread[] handlerArray = new Thread[this.handlerThreads.size()];
        this.handlerThreads.toArray(handlerArray);
        for (int i = 0; i < handlerArray.length; ++i) {
            handlerArray[i].interrupt();
        }
        this.handlerThreads.clear();
        this.statReporter.notifyStatCollectorOfDeletedNode(new IDAddressPair(null, this.selfAddr), this.selfAddr, -1);
        this.sender.connPool.clear();
    }

    public void run() {
        while (true) {
            SocketChannel sock = null;
            try {
                sock = this.servSock.accept();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "ServerSocket#accept() threw an Exception and the receiver will die.");
                return;
            }
            MessageHandlingServer r = new MessageHandlingServer(sock);
            if (this.config.getUseThreadPool()) {
                this.provider.getThreadPool().submit(r);
                continue;
            }
            Thread handlerThread = new Thread(r);
            handlerThread.setDaemon(false);
            handlerThread.setName("MessageHandlingServer: " + sock);
            this.handlerThreads.add(handlerThread);
            handlerThread.start();
        }
    }

    public void addHandler(MessageHandler handler) {
        this.handlerList.add(handler);
    }

    public void removeHandler(MessageHandler handler) {
        this.handlerList.remove(handler);
    }

    private class MessageHandlingServer
    implements Runnable {
        SocketChannel sock;

        MessageHandlingServer(SocketChannel sock) {
            this.sock = sock;
        }

        public void run() {
            while (!Thread.interrupted()) {
                Message msg = null;
                try {
                    msg = Message.decode(this.sock);
                }
                catch (IOException e0) {
                    logger.log(Level.WARNING, "No Message could not be decoded (or just closed).");
                    try {
                        this.sock.close();
                    }
                    catch (IOException e1) {}
                    break;
                }
                byte[] sig = msg.getSignature();
                byte[] acceptableSig = TCPMessageReceiver.this.provider.getMessageSignature();
                if (!Signature.match(sig, acceptableSig)) continue;
                Message ret = null;
                for (MessageHandler handler : TCPMessageReceiver.this.handlerList) {
                    try {
                        ret = handler.process(msg);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "A MessageHandler threw an Exception.", e);
                    }
                }
                if (ret != null) {
                    logger.log(Level.INFO, "Return a message: " + ret);
                    MessagingAddress src = msg.getSource() != null ? msg.getSource().getAddress() : null;
                    try {
                        Message.encode(this.sock, ret);
                        if (src == null) continue;
                        TCPMessageReceiver.this.statReporter.notifyStatCollectorOfMessageSent(src, ret);
                        continue;
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Could not return a message (or just closed).");
                        try {
                            this.sock.close();
                        }
                        catch (IOException e1) {
                            // empty catch block
                        }
                        if (src == null) break;
                        TCPMessageReceiver.this.statReporter.notifyStatCollectorOfDeletedNode(ret.getSource(), src, ret.getTag());
                        break;
                    }
                }
                logger.log(Level.INFO, "Return no message.");
            }
            TCPMessageReceiver.this.handlerThreads.remove(Thread.currentThread());
        }
    }
}

