/*
 * Decompiled with CFR 0.152.
 */
package ow.ipmulticast;

import java.net.Inet4Address;
import java.util.HashSet;
import java.util.Set;
import ow.ipmulticast.FilterMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Host {
    private Inet4Address address;
    private int igmpVersion;
    private final boolean isSelf;
    private long respondedTime;
    private FilterMode filterMode = FilterMode.EXCLUDE;
    private Set<Inet4Address> sourceSet = new HashSet<Inet4Address>();

    Host(Inet4Address address, int igmpVersion, boolean isSelf) {
        this.address = address;
        this.igmpVersion = igmpVersion;
        this.isSelf = isSelf;
        this.respondedTime = System.currentTimeMillis();
    }

    public Inet4Address getAddress() {
        return this.address;
    }

    public int getIGMPVersion() {
        return this.igmpVersion;
    }

    public int setIGMPVersion(int ver) {
        int old = this.igmpVersion;
        this.igmpVersion = ver;
        return old;
    }

    public boolean isSelf() {
        return this.isSelf;
    }

    public long getRespondedTime() {
        return this.respondedTime;
    }

    public long updateRespondedTime() {
        long old = this.respondedTime;
        this.respondedTime = System.currentTimeMillis();
        return old;
    }

    public FilterMode getFilterMode() {
        return this.filterMode;
    }

    public FilterMode setFilterMode(FilterMode newMode) {
        FilterMode old = this.filterMode;
        this.filterMode = newMode;
        return old;
    }

    public void clearSourceSet() {
        this.sourceSet.clear();
    }

    public Set<Inet4Address> getSourceSet() {
        return this.sourceSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSourceSet(Set<Inet4Address> set) {
        Set<Inet4Address> set2 = set;
        synchronized (set2) {
            this.sourceSet.addAll(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSourceSet(Set<Inet4Address> set) {
        Set<Inet4Address> set2 = set;
        synchronized (set2) {
            return this.sourceSet.removeAll(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceSet(Set<Inet4Address> set) {
        this.sourceSet.clear();
        Set<Inet4Address> set2 = set;
        synchronized (set2) {
            this.sourceSet.addAll(set);
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(indent);
        sb.append(this.address);
        sb.append(":IGMPv");
        sb.append(this.igmpVersion);
        sb.append(":");
        sb.append(this.filterMode == FilterMode.EXCLUDE ? "EXCLUDE" : "INCLUDE");
        for (Inet4Address src : this.sourceSet) {
            sb.append(":");
            sb.append(src);
        }
        return sb.toString();
    }
}

