/*
 * Decompiled with CFR 0.152.
 */
package ow.directory.expiration;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import ow.directory.DupDirectory;
import ow.directory.expiration.AbstractExpiringDirectory;
import ow.directory.expiration.ExpiringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpiringDupDirectory<K, V>
extends AbstractExpiringDirectory<K, V>
implements DupDirectory<K, V>,
Serializable {
    private DupDirectory<K, ExpiringValue<V>> dir;

    public ExpiringDupDirectory(DupDirectory<K, ExpiringValue<V>> dir, long defaultTTL, long checkInterval) {
        super(dir, defaultTTL, checkInterval);
        this.dir = dir;
    }

    public V put(K key, V value, long ttl) throws Exception {
        ExpiringValue<V> entry = new ExpiringValue<V>(value, ttl);
        entry = this.dir.put(key, entry);
        V ret = null;
        if (entry != null) {
            ret = entry.getValue();
        }
        return ret;
    }

    @Override
    public V put(K key, V value) throws Exception {
        return this.put(key, value, this.defaultTTL);
    }

    private Set<V> getAndRemove(K key, boolean remove) throws Exception {
        Set<ExpiringValue<V>> c = this.getAndRemoveExpiringValue(key, remove);
        HashSet<V> ret = null;
        if (c != null) {
            ret = new HashSet<V>();
            for (ExpiringValue<V> entry : c) {
                ret.add(entry.getValue());
            }
        }
        return ret;
    }

    private Set<ExpiringValue<V>> getAndRemoveExpiringValue(K key, boolean remove) throws Exception {
        Set<ExpiringValue<V>> s = remove ? this.dir.remove(key) : this.dir.get(key);
        return s;
    }

    @Override
    public Set<V> get(K key) throws Exception {
        return this.getAndRemove(key, false);
    }

    public Set<ExpiringValue<V>> getExpiringValue(K key) throws Exception {
        return this.getAndRemoveExpiringValue(key, false);
    }

    @Override
    public Set<V> remove(K key) throws Exception {
        return this.getAndRemove(key, true);
    }

    @Override
    public V remove(K key, V value) throws Exception {
        ExpiringValue<V> entry = new ExpiringValue<V>(value, this.defaultTTL);
        if ((entry = this.dir.remove(key, entry)) != null) {
            return entry.getValue();
        }
        return null;
    }

    @Override
    public Set<K> keySet() {
        return this.dir.keySet();
    }

    @Override
    public void clear() {
        this.dir.clear();
    }

    @Override
    public void close() {
        super.stopExpiringDaemon();
        this.dir.close();
    }
}

