/**
 * @file ui.h
 * @brief [U[C^[tF[X
 * @author BananaJinn
 * @version $Id: ui.h,v 1.6 2010/11/05 17:24:03 bananajinn Exp $
 * ~Օʉ
 * Copyright (C) 2004-2010 BananaJinn<banana@mxh.mesh.ne.jp>
 */
#ifndef __UI_H__
#define __UI_H__

#include <windows.h>
#include "option.h"

#ifdef __cplusplus
extern "C" {
#endif

#define WM_USER_UICTL	(WM_USER+1)
#define UICTL_METER1INIT	0
#define UICTL_METER2INIT	1
#define UICTL_METER1SETPOS	2
#define UICTL_METER2SETPOS	3
#define UICTL_SETTING		4
#define UICTL_DISPINFO		5
#define UICTL_GETARGREADER	6
#define UICTL_GETARGWRITER	7

extern void UISetHWND(HWND hWnd);
extern BOOL UICheckAbort();
extern void UISetAbort();
extern void UIClearAbort();
extern int UIDispMessage(const char *message, int type);
extern int UIFileDialog(BOOL bOpen, char *filename, int size, const char *suffix);
extern int UIFolderDialog(char *filename, int size);
extern int UINetDialog(BOOL bServer, char *remote, int size, int *port_number);

/* type value */
#define UIDMT_INFORMATION	0
#define UIDMT_ERROR		1
#define UIDMT_QUESTION	2
/* return value */
#define UIDMRET_OK		0
#define UIDMRET_CANCEL	1

extern void UIMeter1Initialize(const char *message);
extern void UIMeter2Initialize(const char *message);
extern void UIMeter1Update(float percentage);
extern void UIMeter2Update(float percentage);
extern void UIDispInfo(const char *message);

extern int UISetting(OPTIONS *option);

#ifdef __cplusplus
}
#endif

#endif /* !__EVENT_H__ */
