/**
 * @file osdepend.h
 * @brief OSˑ
 * @author BananaJinn
 * @version $Id: osdepend.h,v 1.1 2010/11/05 17:24:03 bananajinn Exp $
 * ~Օʉ
 * Copyright (C) 2004-2010 BananaJinn<banana@mxh.mesh.ne.jp>
 */
#ifndef __OSDEPEND_H__
#define __OSDEPEND_H__

#include <windows.h>

#define OSD_FD HANDLE
#define OSD_PID HANDLE

extern BOOL OSDCreateProcess(const char *cmdline, OSD_PID *pid_ret,
							 OSD_FD *stdin_ret, OSD_FD *stdout_ret,
							 OSD_FD *stderr_ret);
extern BOOL OSDTerminateProcess(OSD_PID pid);
extern BOOL OSDWaitProcess(OSD_PID pid, int *exitcode_ret);
extern int OSDRead(OSD_FD fd_stdout, OSD_FD fd_stderr,
				   unsigned char *buff_stdout, int size_stdout,
				   char **stderr_ret);
extern void OSDFDClose(OSD_FD fd);

#endif /** !__OSDEPEND_H__ */
