/**
 * @file osdepend.h
 * @brief OSˑ
 * @author BananaJinn
 * @version $Id: osdepend.c,v 1.1 2010/11/05 17:24:03 bananajinn Exp $
 * ~Օʉ
 * Copyright (C) 2004-2010 BananaJinn<banana@mxh.mesh.ne.jp>
 */
#include <windows.h>
#include "osdepend.h"
#include "ebstring.h"

/**
 * @brief vZX쐬
 * @param[in] cmdline R}hC
 * @param[out] pid_ret vZXID
 * @param[out] stdin_ret W̓fBXNv^
 * @param[out] stdout_ret Wo̓fBXNv^
 * @param[out] stderr_ret WG[o̓fBXNv^
 * @return  TRUE ԂB
 */
BOOL OSDCreateProcess(const char *cmdline, OSD_PID *pid_ret,
					  OSD_FD *stdin_ret, OSD_FD *stdout_ret,
					  OSD_FD *stderr_ret)
{
	HANDLE tmp;
	HANDLE stdin_r, stdin_w;
	HANDLE stdout_r, stdout_w;
	HANDLE stderr_r, stderr_w;
	SECURITY_ATTRIBUTES sa;
	PROCESS_INFORMATION pi;
	STARTUPINFO si;
	BOOL bRet;
	char *cmdline_copy = NULL;

	ZeroMemory(&sa, sizeof(sa));
	sa.nLength = sizeof(SECURITY_ATTRIBUTES);
	sa.bInheritHandle = TRUE;
	
	if(stdin_ret != NULL){
		if(CreatePipe(&stdin_r, &tmp, &sa, 0) == FALSE){
			return FALSE;
		}
		bRet = DuplicateHandle(GetCurrentProcess(), tmp,
							   GetCurrentProcess(), &stdin_w,
							   0, FALSE, DUPLICATE_SAME_ACCESS);
		CloseHandle(tmp);
		if(bRet == FALSE){
			CloseHandle(stdin_r);
			return FALSE;
		}
	}
	if(stdout_ret != NULL){
		if(CreatePipe(&tmp, &stdout_w, &sa, 0) == FALSE){
			if(stdin_ret != NULL){
				CloseHandle(stdin_r);
				CloseHandle(stdin_w);
			}
			return FALSE;
		}
		bRet = DuplicateHandle(GetCurrentProcess(), tmp,
							   GetCurrentProcess(), &stdout_r,
							   0, TRUE, DUPLICATE_SAME_ACCESS);
		CloseHandle(tmp);
		if(bRet == FALSE){
			CloseHandle(stdout_w);
			if(stdin_ret != NULL){
				CloseHandle(stdin_r);
				CloseHandle(stdin_w);
			}
			return FALSE;
		}
	}
	if(stderr_ret != NULL){
		if(CreatePipe(&tmp, &stderr_w, &sa, 0) == FALSE){
			if(stdin_ret != NULL){
				CloseHandle(stdin_r);
				CloseHandle(stdin_w);
			}
			if(stdout_ret != NULL){
				CloseHandle(stdout_r);
				CloseHandle(stdout_w);
			}
			return FALSE;
		}
		bRet = DuplicateHandle(GetCurrentProcess(), tmp,
							   GetCurrentProcess(), &stderr_r,
							   0, TRUE, DUPLICATE_SAME_ACCESS);
		CloseHandle(tmp);
		if(bRet == FALSE){
			CloseHandle(stderr_w);
			if(stdin_ret != NULL){
				CloseHandle(stdin_r);
				CloseHandle(stdin_w);
			}
			if(stdout_ret != NULL){
				CloseHandle(stdout_r);
				CloseHandle(stdout_w);
			}
			return FALSE;
		}
	}

	ZeroMemory(&si, sizeof(si));
	si.cb = sizeof(STARTUPINFO);
	si.dwFlags = STARTF_USESTDHANDLES;
	si.hStdInput = stdin_ret != NULL ?
		stdin_r : GetStdHandle(STD_INPUT_HANDLE);
	si.hStdOutput = stdout_ret != NULL ?
		stdout_w : GetStdHandle(STD_OUTPUT_HANDLE);
	si.hStdError = stderr_ret != NULL ?
		stderr_w : GetStdHandle(STD_ERROR_HANDLE);
	
	cmdline_copy = EbStringNew(cmdline);
	bRet = CreateProcess(NULL, cmdline_copy, NULL, NULL, TRUE,
						 NORMAL_PRIORITY_CLASS|CREATE_NO_WINDOW,
						 NULL, NULL, &si, &pi);
	cmdline_copy = EbStringFree(cmdline_copy);
	if(bRet == FALSE){
		if(stdin_ret != NULL){
			CloseHandle(stdin_r);
			CloseHandle(stdin_w);
		}
		if(stdout_ret != NULL){
			CloseHandle(stdout_r);
			CloseHandle(stdout_w);
		}
		if(stderr_ret != NULL){
			CloseHandle(stderr_r);
			CloseHandle(stderr_w);
		}
		return FALSE;
	}
	if(stdin_ret != NULL){
		*stdin_ret = stdin_w;
		CloseHandle(stdin_r);
	}
	if(stdout_ret != NULL){
		*stdout_ret = stdout_r;
		CloseHandle(stdout_w);
	}
	if(stderr_ret != NULL){
		*stderr_ret = stderr_r;
		CloseHandle(stderr_w);
	}
	*pid_ret = pi.hProcess;
	CloseHandle(pi.hThread);
	Sleep(100);
	return TRUE;
}

/**
 * @brief vZXI
 * @param[in] pid vZXID
 * return  TRUE ԂB
 */
BOOL OSDTerminateProcess(OSD_PID pid)
{
	return TerminateProcess(pid, 0);
}

/**
 * @brief vZX̏I҂
 * @param[in] pid vZXID
 * @param[out] exitcode_ret IR[h
 * @return  TRUE ԂB
 */
BOOL OSDWaitProcess(OSD_PID pid, int *exitcode_ret)
{
	DWORD exitcode = 0;
	
	WaitForSingleObject(pid, INFINITE);
	GetExitCodeProcess(pid, &exitcode);
	CloseHandle(pid);
	if(exitcode_ret != NULL){
		*exitcode_ret = (int)exitcode;
	}

	return TRUE;
}

/**
 * @brief fBXNv^wTCY̓ǂݍ݂sB
 * @param[in] fd_stdout Wo̓fBXNv^
 * @param[in] fd_stderr WG[o̓fBXNv^
 * @param[out] buff_stdout Wo̓obt@
 * @param[in] size_stdout Wo̓obt@TCY
 * @param[out] stderr_ret WG[o͕ԋpp|C^̃AhX
 * @return ǂݍ񂾃TCY(oCg)ԂB
 */
int OSDRead(OSD_FD fd_stdout, OSD_FD fd_stderr,
			unsigned char *buff_stdout, int size_stdout,
			char **stderr_ret)
{
#define ISINVALID(v) ((v)==INVALID_HANDLE_VALUE)
	int ret;
	int offset_stdout = 0;
	char buff_stderr[256+1];
	BOOL done = FALSE;
	BOOL bRet;
	DWORD dwReadBytes;
	DWORD dwAvailBytes;
	
	if(!ISINVALID(fd_stderr)){
		if(stderr_ret != NULL){
			*stderr_ret = NULL;
		}
	}
	
	while(!done && (!ISINVALID(fd_stdout) || !ISINVALID(fd_stderr))){
		if(!ISINVALID(fd_stdout)){
			dwReadBytes = 0;
			bRet = ReadFile(fd_stdout, buff_stdout+offset_stdout,
							size_stdout-offset_stdout,
							&dwReadBytes, NULL);
			if(bRet == FALSE){
				fd_stdout = INVALID_HANDLE_VALUE;
			}
			else{
				offset_stdout += dwReadBytes;
				if(offset_stdout >= size_stdout){
					done = TRUE;
				}
			}
		}
		if(!ISINVALID(fd_stderr)){
			while(TRUE){
				bRet = PeekNamedPipe(fd_stderr, NULL, 0,
									 NULL, &dwAvailBytes, NULL);
				if(bRet == FALSE){
					fd_stderr = INVALID_HANDLE_VALUE;
					break;
				}
				if(dwAvailBytes == 0){
					break;
				}
				if(dwAvailBytes > sizeof(buff_stderr)-1){
					dwAvailBytes = sizeof(buff_stderr)-1;
				}
				bRet = ReadFile(fd_stderr, buff_stderr,
								dwAvailBytes, &dwReadBytes, NULL);
				if(bRet == FALSE){
					fd_stderr = INVALID_HANDLE_VALUE;
					break;
				}
				buff_stderr[dwReadBytes] = '\0';
				*stderr_ret = EbStringAppend(*stderr_ret, buff_stderr);
			}
		}
	}
	return offset_stdout;
}

/**
 * @brief fBXNv^B
 * @param[in] fd fBXNv^
 */
void OSDFDClose(OSD_FD fd)
{
	CloseHandle(fd);
}
