/* ~Օʉ
 * Copyright (c) 2004 Kagetani Hideto
 */
#ifndef __ASPI_H__
#define __ASPI_H__

#include <IOKit/IOKitLib.h>
#include <IOKit/scsi-commands/SCSITaskLib.h>
#include "typedefs.h"

typedef struct {
	int hid;
	int tid;
	DWORD timeout;
	SCSITaskDeviceInterface **interface;
	MMCDeviceInterface **mmcInterface;
	IOCFPlugInInterface **plugInInterface;
} DRIVE;

extern int OpenAspi(void);
extern void CloseAspi(void);
extern int InitializeDrive(DRIVE *drive);
extern void FreeDrive(DRIVE *drive);
extern int SetAspiSetting(DRIVE *drive, int *haid, int *tgid, DWORD *timeout);
extern void GetAspiSetting(DRIVE *drive, int *haid, int *tgid, DWORD *timeout);
extern int SendAspiCmd(DRIVE *drive, BYTE *cdb, BYTE *buf, DWORD buflen,
					   BYTE *sensedata, DWORD senselen, BYTE reqflag);
extern int GetDriveCount(void);
extern UInt64 GettransferCount(void);
extern io_service_t *GetSCSIObject(int drive_number);
extern int GetInquiryString(int targetid, char *buff, int bufsize);
extern BOOL MMCIsWriterDrive(int targetid, char *buff, int bufsize);


#endif /* !__ASPI_H__ */
