/**
 * @file ui.c
 * @author BananaJinn
 * @version $Id: ui.c,v 1.6 2010/11/01 14:34:11 bananajinn Exp $
 * 円盤複写屋
 * Copyright (C) 2004-2010 BananaJinn<banana@mxh.mesh.ne.jp>
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "ui.h"
#include "messagebox.h"
#include "settingdlg.h"
#include "filedlg.h"
#include "netdlg.h"

static BOOL g_bAbort=FALSE;
static GtkWidget *g_WidgetMeter1Label=NULL;
static GtkWidget *g_WidgetMeter1ProgressBar=NULL;
static GtkWidget *g_WidgetMeter2Label=NULL;
static GtkWidget *g_WidgetMeter2ProgressBar=NULL;
static GtkWidget *g_WidgetInfoLabel=NULL;

static void UIFlushMessage()
{
  /*gtk_main_iteration_do(FALSE);*/
  while(gtk_events_pending())
    gtk_main_iteration();
}

BOOL UICheckAbort()
{
  UIFlushMessage();
  return g_bAbort;
}

void UISetAbort()
{
  g_bAbort = TRUE;
}

void UIClearAbort()
{
  g_bAbort = FALSE;
}

int UIDispMessage(const char *message, int type)
{
  gint16 ret;
  guint16 flags;

  switch(type){
  case UIDMT_INFORMATION:
    flags = MBF_TYPEOK | MBF_ICONINFORMATION;
    break;
  case UIDMT_QUESTION:
    flags = MBF_TYPEYESNO | MBF_ICONQUESTION;
    break;
  case UIDMT_ERROR:
    flags = MBF_TYPEOK | MBF_ICONSTOP;
    break;
  default:
    flags = MBF_TYPEOK;
  }

  ret = MessageBoxDlg(message, NULL, flags);
  return (ret==MBR_OK || ret==MBR_YES) ? UIDMRET_OK : UIDMRET_CANCEL;
}

void UISetWidgetMeter1(GtkWidget *label, GtkWidget *progressbar)
{
  g_WidgetMeter1Label = label;
  g_WidgetMeter1ProgressBar = progressbar;
}

void UISetWidgetMeter2(GtkWidget *label, GtkWidget *progressbar)
{
  g_WidgetMeter2Label = label;
  g_WidgetMeter2ProgressBar = progressbar;
}

void UISetWidgetInfo(GtkWidget *label)
{
  g_WidgetInfoLabel = label;
}


void UIMeter1Initialize(const char *message)
{
  if(message==NULL)
    message="";
  if(g_WidgetMeter1Label!=NULL)
    gtk_label_set_text(GTK_LABEL(g_WidgetMeter1Label), message);
  if(g_WidgetMeter1ProgressBar!=NULL)
    gtk_progress_set_percentage(GTK_PROGRESS(g_WidgetMeter1ProgressBar),
				0);
}

void UIMeter2Initialize(const char *message)
{
  if(message==NULL)
    message="";
  if(g_WidgetMeter2Label!=NULL)
    gtk_label_set_text(GTK_LABEL(g_WidgetMeter2Label), message);
  if(g_WidgetMeter2ProgressBar!=NULL)
    gtk_progress_set_percentage(GTK_PROGRESS(g_WidgetMeter2ProgressBar),
				0);
}

void UIMeter1Update(float percentage)
{
  if(percentage < 0)
    percentage = 0;
  if(percentage > 100)
    percentage = 100;

  if(g_WidgetMeter1ProgressBar!=NULL)
    gtk_progress_set_percentage(GTK_PROGRESS(g_WidgetMeter1ProgressBar),
				percentage/100.0);
}

void UIMeter2Update(float percentage)
{
  if(percentage < 0)
    percentage = 0;
  if(percentage > 100)
    percentage = 100;

  if(g_WidgetMeter2ProgressBar!=NULL)
    gtk_progress_set_percentage(GTK_PROGRESS(g_WidgetMeter2ProgressBar),
				percentage/100.0);
}

void UIDispInfo(const char *message)
{
  if(message==NULL)
	message="";
  if(g_WidgetInfoLabel!=NULL)
	gtk_label_set_text(GTK_LABEL(g_WidgetInfoLabel), message);
}


int UISetting(OPTIONS *option)
{
  return SettingDlg(option);
}

int UIFileDialog(BOOL bOpen, char *filename, int size, const char *suffix)
{
  int ret;
  const char *arg = NULL;
  extern const char *GetArgReader();
  extern const char *GetArgWriter();

  /* コマンドライン引数での指定を確認 */
  arg = bOpen ? GetArgReader() : GetArgWriter();
  if(arg != NULL){
	  if(strlen(arg) > 0){
		  /* 指定されていればそえをファイル名として返す */
		  strncpy(filename, arg, size);
		  filename[size-1] = '\0';
		  return UIDMRET_OK;
	  }
  }
  
  ret=FileDialog(bOpen, filename, size, suffix);
  return ret==FDR_OK ? UIDMRET_OK : UIDMRET_CANCEL;
}

int UIFolderDialog(char *filename, int size)
{
	int ret;

	ret=FolderDialog(filename, size);
	return ret==FDR_OK ? UIDMRET_OK : UIDMRET_CANCEL;
}

int UINetDialog(BOOL bServer, char *remote, int size, int *port_number)
{
  int ret;

  ret=NetDialog(bServer, remote, size, port_number);
  return ret==NDR_OK ? UIDMRET_OK : UIDMRET_CANCEL;
}

