/**
 * @file aspi.h
 * @author BananaJinn
 * @version $Id: aspi.h,v 1.6 2010/11/01 14:34:11 bananajinn Exp $
 * 円盤複写屋
 * Copyright (C) 2004-2010 BananaJinn<banana@mxh.mesh.ne.jp>
 */
#ifndef __ASPI_H__
#define __ASPI_H__

#include "typedefs.h"

typedef struct {
  int hid;
  int tid;
  DWORD timeout;
  int fd;
} DRIVE;

extern int OpenAspi(void);
extern void CloseAspi(void);
extern int InitializeDrive(DRIVE *drive);
extern void FreeDrive(DRIVE *drive);
extern int SetAspiSetting(DRIVE *drive, int *ha, int *tg, DWORD *timeout);
extern void GetAspiSetting(DRIVE *drive, int *ha, int *tg, DWORD *timeout);
extern int SendAspiCmd(DRIVE *drive, BYTE *cdb, BYTE *buf, DWORD buflen,
		       BYTE *sensedata, DWORD senselen, BYTE reqflag);
extern int GetHostAdapterCount(void);
extern int GetMaxTarget(void);
extern int GetDeviceIDByName(const char *devfile, int *ha, int *tg);
extern char *GetDeviceNameByID(int ha, int tg);

#endif /* !__ASPI_H__ */
